package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.kafka.Producer;
import com.zorkdata.tools.kafka.ProducerPool;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;
import org.joda.time.DateTime;

import java.util.*;

/**
 * @author zhuzhigang
 */
public class MockStreamxLogAvroTest20201218 {

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "yf170");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.170");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("clustername", "基础监控");

        dimensions.put("appprogramname", "servicecode");
        dimensions.put("servicename", "servicecode");
        dimensions.put("servicecode", "servicecode");
        return dimensions;
    }


    private static Map<String, String> getRandomNormalFieldsError() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update error");
        normalFields.put("collecttime", "testCollecttime");
        return normalFields;
    }

    private static Map<String, String> getRandomNormalFieldsSuccess() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update success");
        normalFields.put("collecttime", "testCollecttime");
        return normalFields;
    }

    public static void main(String[] args) throws Exception {
        DateTime timeStart = new DateTime(2020,12,18,21, 54,07,172);

        String logTypeName = "default_analysis_template";
        String timestamp = timeStart.toString();
        String source = "/var/log/test.log";
        String offset = getRandomOffset();
        Map<String, String> dimensions = getRandomDimensions();
        Map<String, Double> measures = new HashMap<>();
        Map<String, String> normalFields = getRandomNormalFieldsError();


        Producer producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);


        timeStart = new DateTime(2020,12,18,21, 57,52,195);
        timestamp = timeStart.toString();
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);

        timeStart = new DateTime(2020,12,18,21, 57,52,196);
        timestamp = timeStart.toString();
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);

        timeStart = new DateTime(2020,12,18,21, 59,07,205);
        timestamp = timeStart.toString();
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
        Thread.sleep(1000L);

        timeStart = new DateTime(2020,12,18,21, 59,07,206);
        timestamp = timeStart.toString();
        producer = ProducerPool.getInstance().getProducer();
        producer.sendLog("alert_test_source", logTypeName, timestamp, source, offset, dimensions,
                measures, normalFields);
    }
}
