package com.zorkdata.tools.mock.hostAlarm;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author
 *  拓扑
 * 验证只有appsystem、hostname、ip维度的告警机器
 */
public class MetricNoAlarmZork9010 {
    private static String topic = "dwd_all_metric";
//    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
private static String brokerAddr = "shandong1:9092,shandong2:9092";
//    private static String brokerAddr = "noahtest-215:9092,noahtest-216:9092,noahtest-217:9092";
    //    private static String brokerAddr = "shandong1:9092,shandong2:9092,shandong3:9092";
//    private static String brokerAddr = "yf170:9092,yf171:9092,yf172:9092";
//    private static String brokerAddr = "localhost:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static void main(String[] args) throws InterruptedException {
        init();

        //MetricSet
//        String metricSetName = "cpu_system_mb";
        String metricSetName = "original_agent_eb";

        //Dimensions
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("appsystem", "alarm");
        dimensions.put("clustername", "告警集群");
        dimensions.put("appprogramname", "告警模块1");
        dimensions.put("hostname", "zork90-10");//"zorkdata" + i);
        dimensions.put("ip", "192.168.90.10");

        for (int i = 0; i <= 30000; i++) {

            //MetricItem
            Map<String, Double> metrics = new HashMap<>();
            metrics.put("status", 0d);
            //timestamp
            long timestamp = System.currentTimeMillis();
            String timestampString = String.valueOf(timestamp);
            System.out.println("时间："+timestampString);
            //AvroSerializer
            AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
            byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestampString, dimensions, metrics);

            //send
            producerRecord = new ProducerRecord<String, byte[]>(topic, null, bytes);
            producer.send(producerRecord);
            Thread.sleep(15000);
        }
    }
}


