package com.zorkdata.tools.mock;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.joda.time.DateTime;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author DeleMing
 */
@Slf4j
public class MockStreamxMetricAvroFlink {
    private static String topic = "alert_test_source_001";
    private static String brokerAddr = "autotest-3:9092,autotest-2:9092,autotest-1:9092";
    private static ProducerRecord<String, String> producerRecord = null;
    private static KafkaProducer<String, String> producer = null;
    private static DateTime timeStart;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, String>(props);
    }

    public static byte[] buildMetric(double userPct) {
        String metricSetName = "cpu_system_mb";
        String timestamp = String.valueOf(timeStart.getMillis());
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "yf120");//"zorkdata" + i);
        dimensions.put("ip", "192.168.70.120");
        dimensions.put("appsystem", "dev_test");
        dimensions.put("cluster", "基础监控");
        dimensions.put("module", "lmt模块");

        Map<String, Double> metrics = new HashMap<>();
        metrics.put("user_pct", userPct);

        AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
        byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestamp, dimensions, metrics);
        return bytes;
    }

    public static void send(String topic,double userPct) {
        byte[] req = buildMetric(userPct);
        producerRecord = new ProducerRecord<String, String>(
                topic,
                "",
                "a b c d a b d e f"
        );
        producer.send(producerRecord);
    }


    public static void main(String[] args) throws InterruptedException {
        init();
        DateTime timeNow = new DateTime();
        int minute = timeNow.getSecondOfMinute()/15*15;
        timeStart = new DateTime(timeNow.getYear(),timeNow.getMonthOfYear(),timeNow.getDayOfMonth(),timeNow.getHourOfDay(), timeNow.getMinuteOfHour(),minute,000);

        for (int i = 0; i <= 30000; i++) {
            if (i != 0) {
                Thread.sleep(15000);
            }

            int cycle = i%20;
            if (cycle<=11) {
                send(topic,0.5);
            }

            timeStart = timeStart.plusSeconds(15);
        }
    }
}
