package com.zorkdata.tools.mock;

import org.joda.time.DateTime;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author zhuzhigang
 */
public class ScheduledExecutorServiceTest implements ApplicationRunner {

    public static void main(String[] args) throws Exception {
//        String text = "2019-01-03T08:26:15.503162206Z";
//        text = "2021-01-23T08:26:15+08:00";
//        String localTime = "2021-01-23 15:06:20";
////        Date date = utcToLocal(text);
//        Date utcdate = localToUTC(localTime);
//        System.out.println(utcdate);

        String utcString = new DateTime(1611385785000L).toString();
        System.out.println(utcString);

        ScheduledExecutorService service = Executors.newScheduledThreadPool(10);

        long initialDelay = 30000-(DateTime.now().getMillis()%30000);
        long period = 30000;
        // 从现在开始5秒钟之后，每隔30秒钟执行一次job1
        service.scheduleAtFixedRate(new TaskService(), initialDelay, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
    }

    public static Date localToUTC(String localTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date localDate= null;
        try {
            localDate = sdf.parse(localTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        long localTimeInMillis=localDate.getTime();
        /** long时间转换成Calendar */
        Calendar calendar= Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        /** 取得时间偏移量 */
        int zoneOffset = calendar.get(java.util.Calendar.ZONE_OFFSET);
        /** 取得夏令时差 */
        int dstOffset = calendar.get(java.util.Calendar.DST_OFFSET);
        /** 从本地时间里扣除这些差量，即可以取得UTC时间*/
        calendar.add(java.util.Calendar.MILLISECOND, -(zoneOffset + dstOffset));
        /** 取得的时间就是UTC标准时间 */
        Date utcDate=new Date(calendar.getTimeInMillis());
        return utcDate;
    }

    public static Date utcToLocal(String utcTime){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = null;
        try {
            utcDate = sdf.parse(utcTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        sdf.setTimeZone(TimeZone.getDefault());
        Date locatlDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            locatlDate = sdf.parse(localTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return locatlDate;
    }

}


