package com.zorkdata.tools.mock;

import com.zorkdata.tools.avro.AvroSerializer;
import com.zorkdata.tools.avro.AvroSerializerFactory;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author
 *  拓扑
 * 验证只有appsystem、hostname、ip维度的告警机器
 */
public class QQTHostAlarm11 {
    private static String topic = "dwd_all_metric";
    private static String brokerAddr = "node1:9092,node2:9092,node3:9092";
//    private static String brokerAddr = "yf170:9092,yf171:9092,yf172:9092";
//    private static String brokerAddr = "localhost:9092";
    private static ProducerRecord<String, byte[]> producerRecord = null;
    private static KafkaProducer<String, byte[]> producer = null;

    public static void init() {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerAddr);
        props.put("acks", "1");
        props.put("retries", 0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 33554432);
        producer = new KafkaProducer<String, byte[]>(props);
    }

    public static void main(String[] args) throws InterruptedException {
        init();

        //MetricSet
        String metricSetName = "original_agent_eb";

        //Dimensions
        Map<String, String> dimensions = new HashMap<>();
        dimensions.put("appsystem", "alarm");
//        dimensions.put("clustername", "jichujiankong");
//        dimensions.put("appprogramname", "linuxmokuai");
        dimensions.put("hostname", "host-11");
        dimensions.put("ip", "192.168.13.11");

        for (int i = 0; i <= 30000; i++) {

            //MetricItem
            Map<String, Double> metrics = new HashMap<>();
            metrics.put("status", 0d);
            //timestamp
            long timestamp = System.currentTimeMillis();
            String timestampString = String.valueOf(timestamp);
            System.out.println("时间："+timestampString);
            //AvroSerializer
            AvroSerializer metricSerializer = AvroSerializerFactory.getMetricAvroSerializer();
            byte[] bytes = metricSerializer.serializingMetric(metricSetName, timestampString, dimensions, metrics);

            //send
            producerRecord = new ProducerRecord<String, byte[]>(topic, null, bytes);
            producer.send(producerRecord);
            Thread.sleep(15000);
        }
    }


    public static double fun1(int i){
        double tmp = 0;
        if ( i ==0){
            tmp = 0.05;
        }
        if (i == 1){
            tmp = 0.2;
        }
        if (i == 2){
            tmp = 0.2;
        }
        return tmp;
    }
}


