/** @type {import('next').NextConfig} */
const nextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  typescript: {
    ignoreBuildErrors: true,
  },
  images: {
    unoptimized: true,
  },
  // 配置代理规则
  async rewrites() {
    return [
      //认证
      {
        source: '/auth/onlyone/',
        destination: 'http://paas.guotai.com',
      },
      {
        source: '/api/:path*', // 前端请求路径（以 /api 开头的请求）
        destination: 'http://localhost:8080/:path*', // 代理到后端服务地址
      },
    ];
  },
}

export default nextConfig
