import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Progress } from "@/components/ui/progress"
import { PieChart, Pie, Cell, ResponsiveContainer, Legend, Tooltip } from "recharts"

const exporterData = [
  { name: "MySQL", value: 89, percentage: 21.6, color: "#ef4444" },
  { name: "Redis", value: 76, percentage: 18.4, color: "#f97316" },
  { name: "PostgreSQL", value: 54, percentage: 13.1, color: "#22c55e" },
  { name: "MongoDB", value: 43, percentage: 10.4, color: "#06b6d4" },
  { name: "Kafka", value: 32, percentage: 7.8, color: "#3b82f6" },
  { name: "Elasticsearch", value: 29, percentage: 7.0, color: "#8b5cf6" },
  { name: "RabbitMQ", value: 21, percentage: 5.1, color: "#ec4899" },
  { name: "其他", value: 68, percentage: 16.5, color: "#6b7280" },
]

export default function ExporterDistribution() {
  return (
    <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
      {/* Pie Chart */}
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center justify-between">
            <span>Exporter 分布详情</span>
            <Badge variant="outline">实时更新</Badge>
          </CardTitle>
        </CardHeader>
        <CardContent>
          <div className="h-80">
            <ResponsiveContainer width="100%" height="100%">
              <PieChart>
                <Pie
                  data={exporterData}
                  cx="50%"
                  cy="50%"
                  innerRadius={60}
                  outerRadius={120}
                  paddingAngle={2}
                  dataKey="value"
                >
                  {exporterData.map((entry, index) => (
                    <Cell key={`cell-${index}`} fill={entry.color} />
                  ))}
                </Pie>
                <Tooltip
                  formatter={(value: number, name: string) => [
                    `${value} 个 (${exporterData.find((d) => d.name === name)?.percentage}%)`,
                    name,
                  ]}
                />
                <Legend />
              </PieChart>
            </ResponsiveContainer>
          </div>
        </CardContent>
      </Card>

      {/* Distribution List */}
      <Card>
        <CardHeader>
          <CardTitle>组件分布统计</CardTitle>
        </CardHeader>
        <CardContent className="space-y-4">
          {exporterData.map((item) => (
            <div key={item.name} className="space-y-2">
              <div className="flex items-center justify-between">
                <div className="flex items-center space-x-3">
                  <div className="w-3 h-3 rounded-full" style={{ backgroundColor: item.color }} />
                  <span className="font-medium">{item.name}</span>
                </div>
                <div className="flex items-center space-x-2">
                  <span className="text-sm text-gray-600">{item.value}</span>
                  <Badge variant="secondary" className="text-xs">
                    {item.percentage}%
                  </Badge>
                </div>
              </div>
              <Progress value={item.percentage} className="h-2" />
            </div>
          ))}

          <div className="pt-4 border-t">
            <div className="flex justify-between text-sm">
              <span className="text-gray-600">总计</span>
              <span className="font-medium">{exporterData.reduce((sum, item) => sum + item.value, 0)} 个 Exporter</span>
            </div>
          </div>
        </CardContent>
      </Card>
    </div>
  )
}
