package com.zorkdata.desensitization.config;

import com.zorkdata.desensitization.constans.RegExpConstants;
import lombok.Data;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.Map;

/**
 * @author: LiaoMingtao
 * @date: 2020/10/26
 */
@Data
public class RegularExpressions implements Serializable {

    private static final long serialVersionUID = -9099923348992729289L;
    /**
     * 姓名正则表达式
     */
    private String nameRegExp;
    /**
     * 手机号正则表达式
     */
    private String mobileRegExp;
    /**
     * 手机号正则表达式
     */
    private String phoneRegExp;
    /**
     * 邮箱正则表达式
     */
    private String emailRegExp;
    /**
     * 身份证正则表达式
     */
    private String idRegExp;
    /**
     * 银行卡号正则表达式
     */
    private String bankCardRegExp;
    /**
     * 家庭住址正则表达式
     */
    private String addressRegExp;
    /**
     * ip地址正则表达式
     */
    private String ipRegExp;
    /**
     * mac地址正则表达式
     */
    private String macRegExp;

    /**
     * 持仓信息正则
     */
    private String positionExp;

    public RegularExpressions(){

    }

    public RegularExpressions(Map<String, String> map){
        this.nameRegExp = MapUtils.getString(map, RegExpConstants.NAME_REG_EXP);
        this.nameRegExp = MapUtils.getString(map, RegExpConstants.NAME_REG_EXP);
        this.mobileRegExp = MapUtils.getString(map, RegExpConstants.MOBILE_REG_EXP);
        this.phoneRegExp = MapUtils.getString(map, RegExpConstants.PHONE_REG_EXP);
        this.emailRegExp = MapUtils.getString(map, RegExpConstants.EMAIL_REG_EXP);
        this.idRegExp = MapUtils.getString(map, RegExpConstants.ID_REG_EXP);
        this.bankCardRegExp = MapUtils.getString(map, RegExpConstants.BANK_CARD_REG_EXP);
        this.addressRegExp = MapUtils.getString(map, RegExpConstants.ADDRESS_REG_EXP);
        this.ipRegExp = MapUtils.getString(map, RegExpConstants.IP_REG_EXP);
        this.macRegExp = MapUtils.getString(map, RegExpConstants.MAC_REG_EXP);
        this.positionExp = MapUtils.getString(map, RegExpConstants.POSITION_EXP);
    }
}
