package com.zorkdata.desensitization.constans;

/**
 * 配置文件常量key
 *
 * @author: LiaoMingtao
 * @date: 2020/10/26
 */
public final class ConfigConstants {

    public static final String JOB_NAME = "job_name";

    public static final String SOURCE = "source";

    public static final String SOURCE_PARALLELISM = "source.parallelism";
    public static final String TRANSFORMER_PARALLELISM = "transformer.parallelism";
    public static final String SINK_PARALLELISM = "sink.parallelism";
    public static final String REG_DIMENSION = "reg.dimension";

    public static final String HDFS_URI = "hdfs_uri";
    public static final String HDFS_USER = "hdfs_user";
    public static final String HDFS_SRC = "hdfs_src";
    public static final String HDFS_DEST = "hdfs_dest";
    public static final String MATCH_HOSTNAME = "match.hostname";
    public static final String CORE = "core";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";

    public static final String NAME_KEY = "name";
    public static final String MOBILE_KEY = "mobile";
    public static final String PHONE_KEY = "phone";
    public static final String EMAIL_KEY = "email";
    public static final String ID_KEY = "id";
    public static final String BANK_CARD_KEY = "bank_card";
    public static final String ADDRESS_KEY = "address";
    public static final String IP_KEY = "ip";
    public static final String MAC_KEY = "mac";
    public static final String POSITION_KEY = "position";
    public static final String PASSWORD_KEY = "password";
    public static final String HDFS_SOURCE_PATH = "hdfs_source_path";
    public static final String HDFS_SINK_PATH = "hdfs_sink_path";

    public static final String SERVERS = "servers";
    public static final String ZOOKEEPER = "zookeeper";
    public static final String TOPIC = "topic";
    public static final String HDFS = "hdfs";
    public static final String KAFKA = "kafka";

    public static final String FIELDS_WHITE_LIST = "fields_white_list";

    private ConfigConstants() {

    }
}
