package com.zorkdata.desensitization.config;

import com.zorkdata.desensitization.avro.AvroSchemaDef;
import com.zorkdata.desensitization.constans.ConfigConstants;
import com.zorkdata.desensitization.utils.DateUtils;
import lombok.Data;
import org.apache.avro.Schema;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.Map;

/**
 * @author: LiaoMingtao
 * @date: 2021/2/23
 */
@Data
public class JobInitConfig implements Serializable {

    private static final long serialVersionUID = -1959581564693543666L;

    public JobInitConfig(Map<String, String> conf) {
        this.jobName = String.valueOf(conf.get(ConfigConstants.JOB_NAME));
        this.sourceParallelism = Integer.parseInt(conf.get(ConfigConstants.SOURCE_PARALLELISM));
        this.transformerParallelism = Integer.parseInt(conf.get(ConfigConstants.TRANSFORMER_PARALLELISM));
        this.sinkParallelism = Integer.parseInt(conf.get(ConfigConstants.SINK_PARALLELISM));
        this.avroOutputSchema = new Schema.Parser().parse(AvroSchemaDef.ZORK_LOG_SCHEMA).toString(true);
        this.hdfsUri = String.valueOf(conf.get(ConfigConstants.HDFS_URI)).trim();
        this.hdfsUser = String.valueOf(conf.get(ConfigConstants.HDFS_USER)).trim();
        this.hdfsSrc = String.valueOf(conf.get(ConfigConstants.HDFS_SRC)).trim();
        this.hdfsDest = String.valueOf(conf.get(ConfigConstants.HDFS_DEST)).trim();
        this.matchHostname = String.valueOf(conf.get(ConfigConstants.MATCH_HOSTNAME)).trim();
        this.startTime = String.valueOf(conf.get(ConfigConstants.START_TIME));
        this.endTime = String.valueOf(conf.get(ConfigConstants.END_TIME));
        this.startTimestamp = DateUtils.time2Timestamp(startTime);
        this.endTimestamp = DateUtils.time2Timestamp(endTime);
        this.name = MapUtils.getString(conf, ConfigConstants.NAME_KEY);
        this.mobile = MapUtils.getString(conf, ConfigConstants.MOBILE_KEY);
        this.phone = MapUtils.getString(conf, ConfigConstants.PHONE_KEY);
        this.email = MapUtils.getString(conf, ConfigConstants.EMAIL_KEY);
        this.id = MapUtils.getString(conf, ConfigConstants.ID_KEY);
        this.bankCard = MapUtils.getString(conf, ConfigConstants.BANK_CARD_KEY);
        this.address = MapUtils.getString(conf, ConfigConstants.ADDRESS_KEY);
        this.ip = MapUtils.getString(conf, ConfigConstants.IP_KEY);
        this.mac = MapUtils.getString(conf, ConfigConstants.MAC_KEY);
        this.position = MapUtils.getString(conf, ConfigConstants.POSITION_KEY);
        this.password = MapUtils.getString(conf, ConfigConstants.PASSWORD_KEY);
        this.hdfsSourcePath =  MapUtils.getString(conf, ConfigConstants.HDFS_SOURCE_PATH);
        this.hdfsSinkPath =  MapUtils.getString(conf, ConfigConstants.HDFS_SINK_PATH);
    }

    private String jobName;
    private int sourceParallelism;
    private int transformerParallelism;
    private int sinkParallelism;
    private String avroOutputSchema;
    private String hdfsUri;
    private String hdfsUser;
    private String hdfsSrc;
    private String hdfsDest;
    private String matchHostname;
    private String startTime;
    private String endTime;
    private long startTimestamp;
    private long endTimestamp;
    private String hdfsSourcePath;
    private String hdfsSinkPath;


    private String name;
    private String mobile;
    private String phone;
    private String email;
    /**
     * 身份证号
     */
    private String id;
    private String bankCard;
    private String address;
    private String ip;
    private String mac;
    /**
     * 持仓信息
     */
    private String position;
    private String password;
}
