package com.zorkdata.desensitization;

import com.zorkdata.desensitization.config.JobConfig;
import com.zorkdata.desensitization.config.JobInitConfig;
import com.zorkdata.desensitization.exception.ZorkException;
import com.zorkdata.desensitization.hadoop.HdfsLogDesensitization;
import com.zorkdata.desensitization.utils.YmlUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * @author: LiaoMingtao
 * @date: 2020/10/22
 */
@Slf4j
public class TransactionLogDesensitization {

    private static final int PARAM_LENGTH = 2;

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        // 参数校验
        if (args.length != PARAM_LENGTH) {
            String error = "参数缺失,请输入配置文件,例如: " +
                    "--conf E:\\Codes\\fork\\transaction_log_desensitization\\src\\main\\resources\\application.yml";
            log.error(error);
            throw new ZorkException(error);
        }
        Map<String, String> conf = YmlUtils.getParams(args);
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        new HdfsLogDesensitization().initJobConfig(jobConfig).desensitizationHdfsLog();
        Thread.sleep(1000);
        long stop = System.currentTimeMillis();
        log.info("耗时统计: {} ms", stop - start);
    }
}
