package com.zorkdata.desensitization.function;

import com.alibaba.fastjson.JSON;
import com.zorkdata.desensitization.config.JobConfig;
import com.zorkdata.desensitization.config.JobInitConfig;
import com.zorkdata.desensitization.constans.ConfigConstants;
import com.zorkdata.desensitization.constans.GeneralConstants;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;


/**
 * @author: LiaoMingtao
 * @date: 2021/2/25
 */
@Slf4j
public class DesensitizationFunctionTest {
    /**
     * Req Ans 都有
     */
    @Test
    public void test1() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key4");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  Req: ************&key1=value1&key2=value2 Ans: NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000         **************************LEVEL,CODE,MSG;key3,key4,key5;value3,value4,value5,value3,value4,value5&_EORS_2=*****************************;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    /**
     * 只有Req
     */
    @Test
    public void test2() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key4");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  Req: ************&key1=value1&key2=value2 ";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test3() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key2");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=  Ans: NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000         **************************LEVEL,CODE,MSG;key3,key4,key5;value3,value4,value5,value3,value4,value5&_EORS_2=*****************************;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test4() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "custname,otherlinkman,longname,YXYHMC,deputyname");
        conf.put(ConfigConstants.MOBILE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.PHONE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.EMAIL_KEY, "email");
        conf.put(ConfigConstants.ID_KEY, "idno,deputyidno");
        conf.put(ConfigConstants.BANK_CARD_KEY, "lmbankid");
        conf.put(ConfigConstants.ADDRESS_KEY, "addr,workaddr,otheraddr,othertelno");
        conf.put(ConfigConstants.IP_KEY, "printip,ipaddr,operipaddr,clientip");
        conf.put(ConfigConstants.MAC_KEY, "netaddr,clientmac");
        conf.put(ConfigConstants.PASSWORD_KEY, "trdpwd,newpwd,oldfundpwd,newfundpwd,bankpwd,dynamicpwd1,dynamicpwd2,dynamicpwd,fundpwd,newbankpwd");
        conf.put(ConfigConstants.POSITION_KEY, "orderamt,orderqty,orderprice,fundeffect,stkeffect,profitcost,oddqty,sumqty,ordercount,orderqty,orderamt,fundbal,fundavl,marketvalue,fund,stkvalue,stkqty,stkbal,stkavl,mktval,matchamt,fundeffect,fee_yhs,fee_jsxf,fee_sxf,fee_ghf,fee_qsf,fee_jygf,feefront,fee_jsf,fee_zgf,fundbjhgavl,bb_matchclearamt,nHQSBSL,fundeffect,fundbal,fundeffect,bondbal,bondavl,maxdraw,marketvalue,matchqty,funddraw");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "20201227-202920 Req: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20B24, Len=346,Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  010_CA=2.3&_ENDIAN=0&funid=12345&trdpwd=&netaddr=12345678 Ans: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20E24, Len=1284, Buf=01300000000000000000306007060070600740F2E92B8E7AKCXP00 GV2gODkBbGg=5FE87E20006007000005013147410570  01158000000     010_CA=2.3&_SYSID=6007&_ENDIAN=0&_RS_1=MESSAGE;3;LEVEL,CODE,MSG;funid, custname, lmbankid, addr, orderamt;1234,廖鸣韬,464512324564564,123456789,fadfad,1234,廖鸣韬,464512324564564,123456789,fadfad&_EORS_2=2&_RC=2&_CC=48&_TL=3:1;48:1;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test5() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "name,custname,otherlinkman,longname,YXYHMC,deputyname");
        conf.put(ConfigConstants.MOBILE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.PHONE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.EMAIL_KEY, "email");
        conf.put(ConfigConstants.ID_KEY, "idno,deputyidno");
        conf.put(ConfigConstants.BANK_CARD_KEY, "lmbankid");
        conf.put(ConfigConstants.ADDRESS_KEY, "addr,workaddr,otheraddr,othertelno");
        conf.put(ConfigConstants.IP_KEY, "printip,ipaddr,operipaddr,clientip");
        conf.put(ConfigConstants.MAC_KEY, "netaddr,clientmac");
        conf.put(ConfigConstants.PASSWORD_KEY, "trdpwd,newpwd,oldfundpwd,newfundpwd,bankpwd,dynamicpwd1,dynamicpwd2,dynamicpwd,fundpwd,newbankpwd");
        conf.put(ConfigConstants.POSITION_KEY, "orderamt,orderqty,orderprice,fundeffect,stkeffect,profitcost,oddqty,sumqty,ordercount,orderqty,orderamt,fundbal,fundavl,marketvalue,fund,stkvalue,stkqty,stkbal,stkavl,mktval,matchamt,fundeffect,fee_yhs,fee_jsxf,fee_sxf,fee_ghf,fee_qsf,fee_jygf,feefront,fee_jsf,fee_zgf,fundbjhgavl,bb_matchclearamt,nHQSBSL,fundeffect,fundbal,fundeffect,bondbal,bondavl,maxdraw,marketvalue,matchqty,funddraw");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "20201227-235934 " +
                "Req: NodeId=5007, QueueId=430, MsgId=50000006045676B123C23F68, Len=374,  " +
                "Buf=0128000000000000000010000000000000000A94EF138F7F KC XP 00 Gv2gODkBbGq=" +
                "141_CA=2.3G_ENDIAN=0" +
                "&bankpwd=" +
                "&clientflag=0" +
                "&custid=6" +
                "&custorgid=4301" +
                "&ext=" +
                "&funcid=410305" +
                "&g_stationaddr=6CAE8B62900A" +
                "&inputid=10586706&inputinfo=" +
                "&inputtype=Z" +
                "&netaddr=6CAE8B62900A" +
                "&operway=E" +
                "&orgid=4301" +
                "&terminalinfo=" +
                "&trd pwd=llu*;@40z@25" +
                "&serverid=5&g_serverid=5" +
                "Ans: NodeId=5007, QueueId=430, MsgId=50000006045676B123C23F68, Len=1023, Buf=0130000000000000000030500705007050070A94EF138F7FKCX" +
                "GVZgODkBbGg=5FE8AF66005007000003013739410305  00897000000          141_CA=2.3&_SYSID=5007&_ENDIAN=0&_RS_1=MESSAGE;3;LEVEL,CODE,MSG;" +
                "1&_1=0,0,外围登陆成功&_EORS_1=1&_RS_2=DATA;35;" +
                "market,secuid,name,custid,custprop,fundid,custname,orgid,bankcode,timeoutflag,identitysign," +
                "authlevel,pwderrtimes,agtcustid,creditfund,creditflag,netaddr,custkind,custgroup,fundlimit,bankstate," +
                "custodystate,clearstate,lastprintdate,lastprintway,printip,logindate,logintime,outputinfo,operway," +
                "idnoenddate,idnobegindate,outmsg,custstatus,superflag;" +
                "2&_2=1,A641393224,刘梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0," +
                "20200211,0,,20201227,21205975,,012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,0,1&_3=2,0278160114," +
                "刘梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0,20200211,0,,20201227,21205975,," +
                "012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,0,1&_EORS_2=3&_RC=3&_CC=35&_TL=3:1;35:2;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test6() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "name,custname,otherlinkman,longname,YXYHMC,deputyname,fundname");
        conf.put(ConfigConstants.MOBILE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.PHONE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.EMAIL_KEY, "email");
        conf.put(ConfigConstants.ID_KEY, "idno,deputyidno");
        conf.put(ConfigConstants.BANK_CARD_KEY, "lmbankid");
        conf.put(ConfigConstants.ADDRESS_KEY, "addr,workaddr,otheraddr,othertelno");
        conf.put(ConfigConstants.IP_KEY, "printip,ipaddr,operipaddr,clientip");
        conf.put(ConfigConstants.MAC_KEY, "netaddr,clientmac");
        conf.put(ConfigConstants.PASSWORD_KEY, "trdpwd,newpwd,oldfundpwd,newfundpwd,bankpwd,dynamicpwd1,dynamicpwd2,dynamicpwd,fundpwd,newbankpwd");
        conf.put(ConfigConstants.POSITION_KEY, "orderamt,orderqty,orderprice,fundeffect,stkeffect,profitcost,oddqty,sumqty,ordercount,orderqty,orderamt,fundbal,fundavl,marketvalue,fund,stkvalue,stkqty,stkbal,stkavl,mktval,matchamt,fundeffect,fee_yhs,fee_jsxf,fee_sxf,fee_ghf,fee_qsf,fee_jygf,feefront,fee_jsf,fee_zgf,fundbjhgavl,bb_matchclearamt,nHQSBSL,fundeffect,fundbal,fundeffect,bondbal,bondavl,maxdraw,marketvalue,matchqty,funddraw");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "20201227-202920 Req: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20B24, Len=346," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  " +
                "010_CA=2.3&_ENDIAN=0&custid=000004105641&custorgid=3607&ext=&funcid=410570&fundid=0002800713&g_stationaddr=13517951826" +
                "&moneytype=&netaddr=13517951826&operway=&orgid=3607&terminalinfo=&trdpwd=G|8|6l3B&serverid=&sg_server id=6 " +
                "Ans: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20E24, Len=1284, Buf=01300000000000000000306007060070600740F2E92B8E7AKCXP00 " +
                "GV2gODkBbGg=5FE87E20006007000005013147410570  01158000000         010_CA=2.3&_SYSID=6007&_ENDIAN=0&_RS_1=MESSAGE;3;LEVEL,CODE,MSG;" +
                "1&_1=0,0,客户资产总值查询&_EORS_1=1&_RS_2=DATA;48;custid, orgid, brhid, status, fundid, fundname, moneytype, custtype, fundassetbal," +
                "fundassetavl, fundassettotal, fundassettotalnew,fundasset, fundassetstktotal, fundassetstk, fundasaetggt, fundassetstkwxxj,  " +
                "fundassetbondtotal, fundassetbond, fundassetrzgh, fundassetrqgh, fundassetmatchrqgh, fundasaetstkzy, fundassetrzcs, fundassetrqcs,  " +
                "fundassetstkxyzy, fundassetadjust, fundassetadjust_xsf, fundassetadjust_qt, fundassetoftotal, fundassetof, fundassetbjhgsh,  " +
                "fundassetbjhgsz, fundassetofuncome, fundassetx jgj, fundassetzfzz, fundassetjdlsec, fundassetfjjj, fundassetcurdayrqgh,  " +
                "fundassetcurdayrzgh, fundassetotcend, debtstotal, zy_mtkvalue, zy_debts, en_mktvalue, en_debts, zywymktvalue, sumprofitamt;" +
                "2&_2=4105641,3607,3607,0,2800713,潘欣玲,0,0,1000.00,158069.42,825587.15,825587.15,158069.42,331334.56,302463.77,0.00,0.00," +
                "779.99,779.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,28090.80,0.00,28090.80,336183.17,336183.17,0.00,0.00,0.00,55.98,0.00,0.00,0.00," +
                "157013.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,-63104.28&_EORS_2=2&_RC=2&_CC=48&_TL=3:1;48:1;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test8() {
        String a = "market,secuid,name,custid,custprop,fundid,custname,orgid,bankcode,timeoutflag,identitysign,authlevel,pwderrtimes,agtcustid,creditfund,creditflag,netaddr,custkind,custgroup,fundlimit,bankstate,custodystate,clearstate,lastprintdate,lastprintway,printip,logindate,logintime,outputinfo,operway,idnoenddate,idnobegindate,outmsg,custstatus,superflag";
        log.info(String.valueOf(a.split(",").length));
    }

    @Test
    public void test9() {
        String a = "2&_2=1,A641393224,刘梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0," +
                "20200211,0,,20201227,21205975,,012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,0,1&_3=2,0278160114," +
                "刘梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0,20200211,0,,20201227,21205975,," +
                "012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,,0,1&_EORS_2=3&_RC=3&_CC=35&_TL=3:1;35:2;";
        log.info(String.valueOf(a.split(",").length));

    }

    @Test
    public void test10() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "name,custname,otherlinkman,longname,YXYHMC,deputyname");
        conf.put(ConfigConstants.MOBILE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.PHONE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.EMAIL_KEY, "email");
        conf.put(ConfigConstants.ID_KEY, "idno,deputyidno");
        conf.put(ConfigConstants.BANK_CARD_KEY, "lmbankid");
        conf.put(ConfigConstants.ADDRESS_KEY, "addr,workaddr,otheraddr,othertelno");
        conf.put(ConfigConstants.IP_KEY, "printip,ipaddr,operipaddr,clientip");
        conf.put(ConfigConstants.MAC_KEY, "netaddr,clientmac");
        conf.put(ConfigConstants.PASSWORD_KEY, "trdpwd,newpwd,oldfundpwd,newfundpwd,bankpwd,dynamicpwd1,dynamicpwd2,dynamicpwd,fundpwd,newbankpwd");
        conf.put(ConfigConstants.POSITION_KEY, "orderamt,orderqty,orderprice,fundeffect,stkeffect,profitcost,oddqty,sumqty,ordercount,orderqty,orderamt,fundbal,fundavl,marketvalue,fund,stkvalue,stkqty,stkbal,stkavl,mktval,matchamt,fundeffect,fee_yhs,fee_jsxf,fee_sxf,fee_ghf,fee_qsf,fee_jygf,feefront,fee_jsf,fee_zgf,fundbjhgavl,bb_matchclearamt,nHQSBSL,fundeffect,fundbal,fundeffect,bondbal,bondavl,maxdraw,marketvalue,matchqty,funddraw");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "20201227-235934 " +
                "Req: NodeId=5007, QueueId=430, MsgId=50000006045676B123C23F68, Len=374,  " +
                "Buf=0128000000000000000010000000000000000A94EF138F7F KC XP 00 Gv2gODkBbGq=" +
                "141_CA=2.3G_ENDIAN=0" +
                "&bankpwd=" +
                "&clientflag=0" +
                "&custid=6" +
                "&custorgid=4301" +
                "&ext=" +
                "&funcid=410305" +
                "&g_stationaddr=6CAE8B62900A" +
                "&inputid=10586706&inputinfo=" +
                "&inputtype=Z" +
                "&netaddr=6CAE8B62900A" +
                "&operway=E" +
                "&orgid=4301" +
                "&terminalinfo=" +
                "&trd pwd=llu*;@40z@25" +
                "&serverid=5&g_serverid=5" +
                "Ans: NodeId=5007, QueueId=430, MsgId=50000006045676B123C23F68, Len=1023, Buf=0130000000000000000030500705007050070A94EF138F7FKCX" +
                "GVZgODkBbGg=5FE8AF66005007000003013739410305  00897000000          141_CA=2.3&_SYSID=5007&_ENDIAN=0&_RS_1=MESSAGE;3;LEVEL,CODE,MSG;" +
                "1&_1=0,0,外围登陆成功&_EORS_1=1&_RS_2=DATA;35;" +
                "market,secuid,name,custid,custprop,fundid,custname,orgid,bankcode,timeoutflag,identitysign," +
                "authlevel,pwderrtimes,agtcustid,creditfund,creditflag,netaddr,custkind,custgroup,fundlimit,bankstate," +
                "custodystate,clearstate,lastprintdate,lastprintway,printip,logindate,logintime,outputinfo,operway," +
                "idnoenddate,idnobegindate,outmsg,custstatus,superflag;" +
                "2&_2=1,A641393224,刘;梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0," +
                "20200211,0,,20201227,21205975,,012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,0,1&_3=2,0278160114," +
                "刘梦明,55132633,0,10586706,刘梦明,4301,6004,0,,0,0,55132633,0,0,6CAE8B62900A,E,c,,1,o,0,20200211,0,,20201227,21205975,," +
                "012347ADEFGIMNVYcu,20270906,20170906,您的交易密码已经321天未修改,0,1&_EORS_2=3&_RC=3&_CC=35&_TL=3:1;35:2;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }
}