package com.zorkdata.desensitization.function;

import com.alibaba.fastjson.JSON;
import com.zorkdata.desensitization.config.JobConfig;
import com.zorkdata.desensitization.config.JobInitConfig;
import com.zorkdata.desensitization.constans.ConfigConstants;
import com.zorkdata.desensitization.constans.GeneralConstants;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.util.HashMap;
import java.util.Map;


/**
 * @author: LiaoMingtao
 * @date: 2021/2/25
 */
@Slf4j
public class DesensitizationFunctionTest {
    /**
     * Req Ans 都有
     */
    @Test
    public void test1() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key4");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***,\n" +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  Req: ************&key1=value1&key2=value2 Ans: NodeId=***, QueueId=**, MsgId=***********************, Len=***,\n" +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000         **************************LEVEL,CODE,MSG;key3,key4,key5;value3,value4,value5,value3,value4,value5&_EORS_2=*****************************;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    /**
     * 只有Req
     */
    @Test
    public void test2() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key4");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***,\n" +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  Req: ************&key1=value1&key2=value2 ";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test3() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "key1");
        conf.put(ConfigConstants.MOBILE_KEY, "key1");
        conf.put(ConfigConstants.PHONE_KEY, "key1");
        conf.put(ConfigConstants.EMAIL_KEY, "key1");
        conf.put(ConfigConstants.ID_KEY, "key1");
        conf.put(ConfigConstants.BANK_CARD_KEY, "key1");
        conf.put(ConfigConstants.ADDRESS_KEY, "key1");
        conf.put(ConfigConstants.IP_KEY, "key3");
        conf.put(ConfigConstants.MAC_KEY, "key1");
        conf.put(ConfigConstants.PASSWORD_KEY, "key2");
        conf.put(ConfigConstants.POSITION_KEY, "key5");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "YYYYMMDD-*** NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=  Ans: NodeId=***, QueueId=**, MsgId=***********************, Len=***," +
                "Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000         **************************LEVEL,CODE,MSG;key3,key4,key5;value3,value4,value5,value3,value4,value5&_EORS_2=*****************************;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

    @Test
    public void test4() {
        Map<String, String> conf = new HashMap<>(8);
        conf.put(ConfigConstants.JOB_NAME, "jobName");
        conf.put(ConfigConstants.SOURCE_PARALLELISM, "1");
        conf.put(ConfigConstants.TRANSFORMER_PARALLELISM, "1");
        conf.put(ConfigConstants.SINK_PARALLELISM, "1");
        conf.put(ConfigConstants.HDFS_URI, "1");
        conf.put(ConfigConstants.HDFS_USER, "1");
        conf.put(ConfigConstants.HDFS_SRC, "1");
        conf.put(ConfigConstants.HDFS_DEST, "1");
        conf.put(ConfigConstants.MATCH_HOSTNAME, "*");
        conf.put(ConfigConstants.START_TIME, "2020-11-07 21:22:20");
        conf.put(ConfigConstants.END_TIME, "2020-11-07 23:40:30");
        conf.put(ConfigConstants.NAME_KEY, "custname,otherlinkman,longname,YXYHMC,deputyname");
        conf.put(ConfigConstants.MOBILE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.PHONE_KEY, "netaddr,telno,mobileno,faxno,hometelno,worktelno,fax,mobil,call");
        conf.put(ConfigConstants.EMAIL_KEY, "email");
        conf.put(ConfigConstants.ID_KEY, "idno,deputyidno");
        conf.put(ConfigConstants.BANK_CARD_KEY, "lmbankid");
        conf.put(ConfigConstants.ADDRESS_KEY, "addr,workaddr,otheraddr,othertelno");
        conf.put(ConfigConstants.IP_KEY, "printip,ipaddr,operipaddr,clientip");
        conf.put(ConfigConstants.MAC_KEY, "netaddr,clientmac");
        conf.put(ConfigConstants.PASSWORD_KEY, "trdpwd,newpwd,oldfundpwd,newfundpwd,bankpwd,dynamicpwd1,dynamicpwd2,dynamicpwd,fundpwd,newbankpwd");
        conf.put(ConfigConstants.POSITION_KEY, "orderamt,orderqty,orderprice,fundeffect,stkeffect,profitcost,oddqty,sumqty,ordercount,orderqty,orderamt,fundbal,fundavl,marketvalue,fund,stkvalue,stkqty,stkbal,stkavl,mktval,matchamt,fundeffect,fee_yhs,fee_jsxf,fee_sxf,fee_ghf,fee_qsf,fee_jygf,feefront,fee_jsf,fee_zgf,fundbjhgavl,bb_matchclearamt,nHQSBSL,fundeffect,fundbal,fundeffect,bondbal,bondavl,maxdraw,marketvalue,matchqty,funddraw");
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        DesensitizationFunction<Object, Object> desensitizationFunction = new DesensitizationFunction(jobConfig);
        Map<String, String> map = new HashMap<>(8);
        String message = "20201227-202920 Req: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20B24, Len=346,Buf=01280000000000000000100000000000000040F2E92B8E7AKCXP00  GV2gODkBbGg=       410570 00220000000  010_CA=2.3&_ENDIAN=0&funid=12345&trdpwd=&netaddr=12345678 Ans: NodeId=6007, QueueId=304, MsgId=6000000604B2949123C20E24, Len=1284, Buf=01300000000000000000306007060070600740F2E92B8E7AKCXP00 GV2gODkBbGg=5FE87E20006007000005013147410570  01158000000     010_CA=2.3&_SYSID=6007&_ENDIAN=0&_RS_1=MESSAGE;3;LEVEL,CODE,MSG;funid, custname, lmbankid, addr, orderamt;1234,廖鸣韬,464512324564564,123456789,fadfad,1234,廖鸣韬,464512324564564,123456789,fadfad&_EORS_2=2&_RC=2&_CC=48&_TL=3:1;48:1;";
        map.put(GeneralConstants.MESSAGE, message);
        desensitizationFunction.desensitizationNormalFieldMessage(map);
        log.info(JSON.toJSONString(map));
    }

}