#!/usr/bin/env bash

# 默认等待项目启动时间
DEFAULT_SLEEP_TIME=30
# 必须修改
CDH_HOST_IP=192.168.70.2
CDH_HOST_USER=root
CDH_HOST_PASSWORD=password
CDH_HDFS_USER=hdfs

# 与配置文件保持一致
HDFS_DEST=/tmp/datawarehouse/jzjy/kcbp_biz_log/output1/
DOWNLOAD_PATH=/tmp/
JOB_NAME="国泰交易日志脱敏job"

FLINK_TASK_CONF=application.yml
REGULAR_TASK_NAME=regular

LOCAL_IP=$(ip a |grep inet| grep -v inet6 | grep -v 127 | cut -d '/' -f1 | cut -d ' ' -f6)

export BASE_PATH=$(cd `dirname $0`; pwd)
DEPLOY_PATH=${BASE_PATH%/*}
if [ ! -d "$DEPLOY_PATH/logs" ]; then
  mkdir -p $DEPLOY_PATH/logs
fi

# 取值配置文件
IFS=': '
while read k v
do
  if [[ "$k" == "hdfs_dest" ]]
  then
    HDFS_DEST=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "download_path" ]]
  then
    DOWNLOAD_PATH=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "job_name" ]]
  then
    JOB_NAME=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_ip" ]]
  then
    CDH_HOST_IP=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_user" ]]
  then
    CDH_HOST_USER=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_password" ]]
  then
    CDH_HOST_PASSWORD=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_hdfs_user" ]]
  then
    CDH_HDFS_USER=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
done < $DEPLOY_PATH/conf/$FLINK_TASK_CONF

echo "开始提交任务"


flink run -d -c com.zorkdata.desensitization.TransactionLogDesensitization $DEPLOY_PATH/lib/transaction-log-desensitization-0.1.jar --conf $DEPLOY_PATH/conf/$FLINK_TASK_CONF > $DEPLOY_PATH/logs/submit.log &

sleep $DEFAULT_SLEEP_TIME

TASK_STATUS=$(cat $DEPLOY_PATH/logs/submit.log |grep "Job has been submitted with JobID")
if [[ "$TASK_STATUS" == "" ]]
then
  echo "提交任务失败"
  exit 8
fi

SCP_PATH=$DOWNLOAD_PATH$(echo $HDFS_DEST|rev |cut -d '/' -f 2 | rev)/
download(){
expect <<EOF
  set timeout 10
  spawn ssh $CDH_HOST_USER@$CDH_HOST_IP
  expect {
          "yes/no" { send "yes\n";exp_continue }
          "password:" { send "$CDH_HOST_PASSWORD\n" }
  }
  expect "]# " { send "rm -rf $SCP_PATH\n" }
  expect "]# " { send "su $CDH_HDFS_USER\n" }
  expect "]$ " { send "hadoop fs -copyToLocal $HDFS_DEST $DOWNLOAD_PATH\n" }
  expect "]# " { send "exit\n" }
  expect "]# " {
          send "scp -r $SCP_PATH root@$LOCAL_IP:/tmp/\n"
          expect {
                  "yes/no" { send "yes\n";exp_continue }
                  "password: " { send "$CDH_HOST_PASSWORD\n" }
          }
          expect "]# " { send "exit\n" }
  }
  expect "]# " { send "exit\n" }
EOF
}

while :
do
  FLINK_LIST_RUNNING=$(flink list -r )
  FLAG=$(echo $FLINK_LIST_RUNNING | grep "$JOB_NAME")
  if [[ "$FLAG" == "" ]]
  then
    echo "开始下载"
    download
    break
  fi
done