package com.zorkdata.desensitization.utils;


import com.zorkdata.desensitization.exception.ZorkException;
import lombok.extern.slf4j.Slf4j;
import org.apache.flink.api.java.utils.ParameterTool;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: LiaoMingtao
 * @date: 2020/10/22
 */
@Slf4j
public class YmlUtil {

    private YmlUtil() {
    }

    private static final String YML_SUFFIX = "yml";
    private static final String CONF_PARAM = "conf";
    private static final int DEFAULT_PARAMS_MAP_LENGTH = 10;

    @SuppressWarnings("all")
    public static Map<String, String> getParams(String[] args) throws ZorkException {
        Map<String, String> confMap = new HashMap<>(DEFAULT_PARAMS_MAP_LENGTH);
        String configPath = null;
        ParameterTool parameterTool = ParameterTool.fromArgs(args);
        configPath = parameterTool.get(CONF_PARAM);
        log.info("read config path is {}", configPath);
        if (!configPath.endsWith(YML_SUFFIX)) {
            log.info("Please input correct configuration file and flink run mode!");
        } else {
            confMap = LoadConf.loadYaml(configPath);
            if (confMap.isEmpty()) {
                log.error("配置文件" + args[0] + "不存在,系统退出");
                throw new ZorkException(String.format("配置文件%s不存在,系统退出", args[0]));
            }
        }
        return confMap;
    }


}
