package com.zorkdata.desensitization.function;

import com.alibaba.fastjson.JSON;
import com.zorkdata.desensitization.config.RegularExpressions;

import java.io.Serializable;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author: LiaoMingtao
 * @date: 2020/10/26
 */
public class DesensitizationFunction implements Serializable {

    private static final long serialVersionUID = 1L;

    private RegularExpressions regularExpressions;

    private List<Pattern> patterns = new ArrayList<>();


    public DesensitizationFunction(RegularExpressions regularExpressions) {
        this.regularExpressions = regularExpressions;
        patterns.add(Pattern.compile(regularExpressions.getIdRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getBankCardRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getPhoneRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getMobileRegExp()));

        patterns.add(Pattern.compile(regularExpressions.getAddressRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getPositionExp()));
        patterns.add(Pattern.compile(regularExpressions.getNameRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getMacRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getEmailRegExp()));
        patterns.add(Pattern.compile(regularExpressions.getIpRegExp()));
    }

    public Map<String, String> desensitization(Map<String, String> map,
                                               List<String> whiteList, List<String> dataFormats) {
        Iterator<Map.Entry<String, String>> entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> next = entryIterator.next();
            String key = next.getKey();
            String value = next.getValue();
            if (!whiteList.contains(key)) {
                // 执行脱敏操作
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(value);
                    if (matcher.find()) {
                        String replaceStr = "";
                        for (int i = 0; i < matcher.group().length(); i++) {
                            String s = String.valueOf(matcher.group().charAt(i));
                            if(dataFormats.contains(s)){
                                replaceStr = replaceStr.concat(s);
                            }else{
                                replaceStr = replaceStr.concat("*");
                            }
                        }
                        value = value.replace(matcher.group(), replaceStr);
                        map.put(key, value);
                    }
                }
            }
        }
        return map;
    }

    public Map desensitizationTemp(Map map, List<String> whiteList, List<String> dataFormats) {
        map.forEach((k, v) -> {
            if (!whiteList.contains(k)) {
                String value = v.toString();
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(value);
                    if (matcher.find()) {
                        String replaceStr = "";
                        for (int i = 0; i < matcher.group().length(); i++) {
                            String s = String.valueOf(matcher.group().charAt(i));
                            if(dataFormats.contains(s)){
                                replaceStr = replaceStr.concat(s);
                            }else{
                                replaceStr = replaceStr.concat("*");
                            }
                        }
                        value = value.replace(matcher.group(), replaceStr);
                        System.out.println("\n");
                    }
                }
                map.put(k, value);
            } else {
                map.put(k, v);
            }
        });
        return map;
    }

}
