#!/usr/bin/env bash

# 必须修改
CDH_HOST_IP=192.168.70.2
CDH_HOST_USER=root
CDH_HOST_PASSWORD=password

# 与配置文件保持一致
HDFS_DEST=/tmp/datawarehouse/jzjy/kcbp_biz_log/output1/
DOWNLOAD_PATH=/tmp/
JOB_NAME="国泰交易日志脱敏job"

FLINK_TASK_CONF=application.yml
REGULAR_TASK_NAME=regular
SCP_PATH=$DOWNLOAD_PATH$(echo $HDFS_DEST|rev |cut -d '/' -f 2 | rev)/
LOCAL_IP=$(ip a |grep inet| grep -v inet6 | grep -v 127 | cut -d '/' -f1 | cut -d ' ' -f6)

export BASE_PATH=$(cd `dirname $0`; pwd)
DEPLOY_PATH=${BASE_PATH%/*}
if [ ! -d "$DEPLOY_PATH/logs" ]; then
  mkdir -p $DEPLOY_PATH/logs
fi

# 取值配置文件
IFS=': '
while read k v
do
  if [[ "$k" == "hdfs_dest" ]]
  then
    HDFS_DEST=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "download_path" ]]
  then
    DOWNLOAD_PATH=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "job_name" ]]
  then
    JOB_NAME=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_ip" ]]
  then
    CDH_HOST_IP=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_user" ]]
  then
    CDH_HOST_USER=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
  if [[ "$k" == "cdh_host_password" ]]
  then
    CDH_HOST_PASSWORD=$(echo "$v" | sed -r 's/.*"(.+)".*/\1/')
  fi
done < $DEPLOY_PATH/conf/$FLINK_TASK_CONF

echo $HDFS_DEST
echo $DOWNLOAD_PATH
echo $JOB_NAME
echo $CDH_HOST_IP
echo $CDH_HOST_USER
echo $CDH_HOST_PASSWORD


flink run -d -c com.zorkdata.desensitization.TransactionLogDesensitization $DEPLOY_PATH/lib/transaction-log-desensitization-0.1.jar --conf $DEPLOY_PATH/conf/$FLINK_TASK_CONF --regular $DEPLOY_PATH/conf/$REGULAR_TASK_NAME > $DEPLOY_PATH/logs/submit.log &

sleep 10

TASK_STATUS=$(cat $DEPLOY_PATH/logs/submit.log |grep "Job has been submitted with JobID")
if [[ "$TASK_STATUS" == "" ]]
then
  echo "提交任务失败"
  exit 8
fi

download(){
expect <<EOF
  set timeout 10
  spawn ssh $CDH_HOST_USER@$CDH_HOST_IP
  expect {
          "yes/no" { send "yes\n";exp_continue }
          "password:" { send "$CDH_HOST_PASSWORD\n" }
  }
  expect "]# " { send "sudo -u hdfs hadoop fs -copyToLocal $HDFS_DEST $DOWNLOAD_PATH\n" }
  expect "]# " {
          send "scp -r $SCP_PATH root@$LOCAL_IP:/tmp/\n"
          expect {
                  "yes/no" { send "yes\n";exp_continue }
                  "password: " { send "$CDH_HOST_PASSWORD\n" }
          }
          expect "]# " { send "exit\n" }
  }
  expect "]# " { send "exit\n" }
EOF
}

while :
do
  FLINK_LIST_RUNNING=$(flink list -r )
  FLAG=$(echo $FLINK_LIST_RUNNING | grep "$JOB_NAME")
  if [[ "$FLAG" == "" ]]
  then
    download
    break
  fi
done