package com.zorkdata.desensitization;

import com.zorkdata.desensitization.constans.ConfigConstants;
import com.zorkdata.desensitization.exception.ZorkException;
import com.zorkdata.desensitization.hadoop.HdfsLogDesensitization;
import com.zorkdata.desensitization.utils.PropertiesUtil;
import com.zorkdata.desensitization.utils.YmlUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * @author: LiaoMingtao
 * @date: 2020/10/22
 */
@Slf4j
public class TransactionLogDesensitization {

    private static final int PARAM_LENGTH = 4;

    public static void main(String[] args) throws Exception{
        long start = System.currentTimeMillis();
        if (args.length != PARAM_LENGTH) {
            String error = "参数缺失,请输入配置文件,例如: " +
                    "--conf E:\\Codes\\fork\\transaction_log_desensitization\\src\\main\\resources\\application.yml " +
                    "--regular E:\\Codes\\fork\\transaction_log_desensitization\\src\\main\\resources\\regular ";
            log.error(error);
        }
        try {
            Map<String, String> conf = YmlUtil.getParams(args);
            Map<String, String> regularMap = PropertiesUtil.getPropertiesMap(args);
            String source = conf.get(ConfigConstants.SOURCE);
            if (ConfigConstants.HDFS.equals(source)) {
                new HdfsLogDesensitization().initConf(conf).initRegular(regularMap).desensitizationHdfsLog();
            }
            if (ConfigConstants.KAFKA.equals(source)) {
                // TODO kafka
            }
        } catch (ZorkException e) {
            log.info(String.valueOf(e));
        }
        long stop = System.currentTimeMillis();
        System.out.println("耗时统计:" + (stop - start) + "ms");
    }
}
