package com.zorkdata.desensitization.hadoop;

import com.alibaba.fastjson.JSON;
import com.zorkdata.desensitization.config.JobConfig;
import com.zorkdata.desensitization.config.JobInitConfig;
import com.zorkdata.desensitization.utils.YmlUtils;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.util.List;
import java.util.Map;


/**
 * @author: LiaoMingtao
 * @date: 2021/3/9
 */
@Slf4j
public class HdfsLogDesensitizationTest {

    @Test
    public void filterHdfsLogFiles() throws Exception {
        String[] args = new String[]{"--conf", "E:\\Codes\\fork\\transaction-log-desensitization\\src\\main\\resources\\application.yml"};
        Map<String, String> conf = YmlUtils.getParams(args);
        JobInitConfig jobInitConfig = new JobInitConfig(conf);
        JobConfig jobConfig = new JobConfig(jobInitConfig);
        HdfsLogDesensitization hdfsLogDesensitization = new HdfsLogDesensitization().initJobConfig(jobConfig);
        List<String> strings = hdfsLogDesensitization
                .filterHdfsLogFiles(jobConfig.getHdfsSrc(), jobConfig.getHdfsUri(), jobConfig.getHdfsUser());
        log.info(JSON.toJSONString(strings));
    }
}