package com.zorkdata.desensitization.config;

import com.zorkdata.desensitization.constans.GeneralConstants;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: LiaoMingtao
 * @date: 2021/2/23
 */
@Data
public class JobConfig implements Serializable {

    private static final long serialVersionUID = 693924914570906529L;

    public JobConfig(JobInitConfig jobInitConfig) {
        this.setJobName(jobInitConfig.getJobName());
        this.setSourceParallelism(jobInitConfig.getSourceParallelism());
        this.setTransformerParallelism(jobInitConfig.getTransformerParallelism());
        this.setSinkParallelism(jobInitConfig.getSinkParallelism());
        this.setAvroOutputSchema(jobInitConfig.getAvroOutputSchema());
        this.setHdfsUri(jobInitConfig.getHdfsUri());
        this.setHdfsUser(jobInitConfig.getHdfsUser());
        this.setHdfsSrc(jobInitConfig.getHdfsUri() + jobInitConfig.getHdfsSrc());
        this.setHdfsDest(jobInitConfig.getHdfsDestUri() + jobInitConfig.getHdfsDest());
        this.setMatchHostname(jobInitConfig.getMatchHostname());
        this.setStartTime(jobInitConfig.getStartTime());
        this.setEndTime(jobInitConfig.getEndTime());
        this.setStartTimestamp(jobInitConfig.getStartTimestamp());
        this.setEndTimestamp(jobInitConfig.getEndTimestamp());
        String password = jobInitConfig.getPassword() + GeneralConstants.COMMA;
        String name = jobInitConfig.getName() + GeneralConstants.COMMA;
        String mobile = jobInitConfig.getMobile() + GeneralConstants.COMMA;
        String phone = jobInitConfig.getPhone() + GeneralConstants.COMMA;
        String email = jobInitConfig.getEmail() + GeneralConstants.COMMA;
        String id = jobInitConfig.getId() + GeneralConstants.COMMA;
        String address = jobInitConfig.getAddress() + GeneralConstants.COMMA;
        String bankCard = jobInitConfig.getBankCard() + GeneralConstants.COMMA;
        String ip = jobInitConfig.getIp() + GeneralConstants.COMMA;
        String mac = jobInitConfig.getMac() + GeneralConstants.COMMA;
        String position = jobInitConfig.getPosition() + GeneralConstants.COMMA;
        String allKey = password + name + mobile + phone + email + id + address + bankCard + ip + mac + position;
        String[] keys = allKey.split(GeneralConstants.COMMA);
        List<String> keyList = new ArrayList<>();
        for (String key : keys) {
            if (!GeneralConstants.EMPTY_STR.equals(key)) {
                keyList.add(key);
            }
        }
        keyList = keyList.stream().distinct().collect(Collectors.toList());
        this.setDesensitizationKeyList(keyList);
        this.hdfsSourcePath = jobInitConfig.getHdfsSourcePath();
        this.hdfsSinkPath = jobInitConfig.getHdfsSinkPath();
    }

    private String jobName;
    private int sourceParallelism;
    private int transformerParallelism;
    private int sinkParallelism;
    private String avroOutputSchema;
    private String hdfsUri;
    private String hdfsUser;
    private String hdfsSrc;
    private String hdfsDest;
    private String matchHostname;

    private String startTime;
    private String endTime;
    private long startTimestamp;
    private long endTimestamp;
    private List<String> desensitizationKeyList;

    private String hdfsSourcePath;
    private String hdfsSinkPath;

}
