package com.zorkdata.tools.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.log4j.PropertyConfigurator;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author DeleMing
 */
@Slf4j
public class PropertiesUtil {

    private PropertiesUtil() {

    }

    /**
     * 根据文件名获取该properties对象
     *
     * @param propertiesFileName 配置文件名称
     * @return properties
     */
    public static Properties getProperties(String propertiesFileName) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = PropertiesUtil.class.getResourceAsStream(propertiesFileName);
            properties.load(inputStream);
        } catch (IOException e) {
            log.error("读取配置文件失败:", e);
            System.exit(1);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    public static Properties getPropertiesByUserDir(String propertiesFileName) {
        Properties properties = null;
        InputStream inputStream = null;
        try {
            PropertyConfigurator.configure(System.getProperty("user.dir") + propertiesFileName);
            properties = new Properties();
            // 读取SRC下配置文件 --- 属于读取内部文件
            // 读取系统外配置文件 (即Jar包外文件) --- 外部工程引用该Jar包时需要在工程下创建config目录存放配置文件
            String filePath = System.getProperty("user.dir") + propertiesFileName;
            inputStream = new BufferedInputStream(new FileInputStream(filePath));
            properties.load(inputStream);
        } catch (IOException e) {
            log.error("读取配置文件失败:", e);
            System.exit(1);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }
}
