package com.zorkdata.tools.oldmock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.oldkafka.Producer;
import com.zorkdata.tools.oldkafka.ProducerPool;
import com.zorkdata.tools.utils.DateUtil;
import com.zorkdata.tools.utils.PropertiesUtil;
import com.zorkdata.tools.utils.StringUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

/**
 * @author: LiaoMingtao
 * @date: 2020/6/28
 */
public class MockStreamxMetricAvro {
    private static long getSize(String propertiesName) throws Exception {

        Properties properties = PropertiesUtil.getProperties(propertiesName);
        long logSize = StringUtil.getLong(properties.getProperty("log.size", "5000").trim(), 1);
        return logSize;
    }

    public static String printData(String logTypeName, String timestamp, String source, String offset,
                                   Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("logTypeName", logTypeName);
        jsonObject.put("timestamp", timestamp);
        jsonObject.put("source", source);
        jsonObject.put("offset", offset);
        jsonObject.put("dimensions", dimensions);
        jsonObject.put("measures", metrics);
        jsonObject.put("normalFields", normalFields);
        return jsonObject.toString();
    }

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>();

        dimensions.put("hostname", "zorkdata" + i);
        dimensions.put("ip", "192.168.1." + i);
        dimensions.put("appprogramname", "tc50");
        dimensions.put("appsystem", "tdx");

        return dimensions;
    }

    private static String[] codes = {
            "AO", "AF", "AL", "DZ", "AD", "AI", "AG", "AR", "AM", "AU",
            "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ"
    };

    private static String getRandomCountryCode() {
        Random random = new Random(codes.length);
        return codes[new Random(codes.length).nextInt(codes.length)];
    }

    private static Map<String, String> getRandomNormalFields() {
        Map<String, String> normalFields = new HashMap<>();
        normalFields.put("message", "data update success");
        normalFields.put("countryCode", getRandomCountryCode());
        return normalFields;
    }

    private static Map<String, Double> getMetrics() {
        Map<String, Double> metrics = new HashMap<>(1);
        Random random = new Random();
        int i = random.nextInt(10);
        metrics.put("metric1", i * 0.1);
        metrics.put("metric2", i * 0.2);
        metrics.put("metric3", i * 3.65);
        return metrics;
    }


    public static void main(String[] args) throws Exception {
        long size = 10000000 * 20;

        for (int i = 0; i < size; i++) {
            String metricSetName = "streamx_metric_avro";
            String timestamp = DateUtil.getUTCTimeStr();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> metrics = getMetrics();

            //System.out.println(printData(logTypeName, timestamp, source, offset, dimensions, measures, normalFields));
            Producer producer = ProducerPool.getInstance().getProducer();
            producer.sendMetric("metric2metric20000w", metricSetName, timestamp, dimensions, metrics);
        }
        Thread.sleep(1000);
    }
}
