package com.zorkdata.tools.oldmock;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.zorkdata.tools.oldkafka.Producer;
import com.zorkdata.tools.oldkafka.ProducerPool;
import com.zorkdata.tools.utils.StringUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LogAvroProducer {

    public static final String MEASURES = "measures";
    public static final String DIMENSIONS = "dimensions";
    public static final String TIMESTAMP = "timestamp";
    public static final String LOGTYPENAME = "logTypeName";
    public static final String NORMALFIELDS = "normalFields";
    public static final String SOURCE = "source";
    public static final String OFFSET = "offset";


    public static final String APPSYSTEM = "appsystem";
    public static final String NULLSTR = "";

    public static void main(String[] args) {
        int total = 10 * 1000 * 1000 * 100;
        int i = 0;
        Long begin = System.currentTimeMillis();
        while (i < total) {
            Date d = new Date();
            JSONObject logType = new JSONObject();
            logType.put(LOGTYPENAME, "streamx_log_avro");
            logType.put(TIMESTAMP, d.getTime());
            logType.put(SOURCE, "0");
            logType.put(OFFSET, "0");
            JSONObject dimensions = new JSONObject();
            dimensions.put("hostname", "zorkdata" + i);
            dimensions.put("appprogramname", "zorkdata" + i);
            dimensions.put("ip", "192.168.1.1");
            dimensions.put("appsystem", "zorkdata" + i);
            JSONObject normalFields = new JSONObject();
            normalFields.put("countryCode", "SZ" + i);
            normalFields.put("message", "ABCD" + i);
            JSONObject measures = new JSONObject();
            logType.put(DIMENSIONS, dimensions);
            logType.put(NORMALFIELDS, normalFields);
            logType.put(MEASURES, measures);
            sendWhileData("bigdata1", logType);
            i++;
        }
        Long end = System.currentTimeMillis();
        System.out.println("总耗时：" + (end - begin));
    }


    public static String sendWhileData(String topic, JSONObject log) {
        try {
            String logTypeName = log.getString(LOGTYPENAME);
            String _timestamp = log.getString(TIMESTAMP);
            String timestamp = StringUtil.getISOTime(_timestamp);
            String source = log.getString(SOURCE);
            String offset = log.getString(OFFSET);
            if (source == null) {
                source = NULLSTR;
            }
            if (offset == null) {
                offset = NULLSTR;
            }
            JSONObject dimensions = log.getJSONObject(DIMENSIONS);
            JSONObject normalFields = log.getJSONObject(NORMALFIELDS);
            JSONObject measures = log.getJSONObject(MEASURES);
            String appSystem = dimensions.getString(APPSYSTEM);

            Map<String, String> dimensionsMap = dimensions != null ? JSONObject.parseObject(dimensions.toJSONString(), new TypeReference<Map<String, String>>() {
            }) : new HashMap<>();
            Map<String, String> normalFieldsMap = normalFields != null ? JSONObject.parseObject(normalFields.toJSONString(), new TypeReference<Map<String, String>>() {
            }) : new HashMap<>();
            Map<String, Double> measuresMap = measures != null ? JSONObject.parseObject(measures.toJSONString(), new TypeReference<Map<String, Double>>() {
            }) : new HashMap<>();
            Producer producer = ProducerPool.getInstance().getProducer();
            producer.sendLog(topic, logTypeName, timestamp, source, offset, dimensionsMap,
                    measuresMap, normalFieldsMap);
//            System.out.println("white list send [" + logTypeName + "] success");
            return "ok";
        } catch (Exception e) {
            System.out.println("Please define the log set. The data you sent through the whitelist is in an incorrect format");
            return "faild";
        }
    }
}
