package com.zorkdata.tools.mock;

import com.zorkdata.tools.utils.DateUtil;
import org.mortbay.util.ajax.JSON;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * @author MSI-Gaming
 */
public class MockStreamxLogAvro {

    private static String getRandomOffset() {
        Random random = new Random();
        long l = random.nextInt(10000);
        return String.valueOf(l);
    }

    private static Map<String, String> getRandomDimensions() {
        Random random = new Random();
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>(4);
        dimensions.put("hostname", "zorkdata" + i);
        dimensions.put("ip", "192.168.1." + i);
        dimensions.put("appprogramname", "tc50");
        dimensions.put("appsystem", "tdx");
        return dimensions;
    }

    private static String[] codes = {
            "AO", "AF", "AL", "DZ", "AD", "AI", "AG", "AR", "AM", "AU",
            "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ"
    };

    private static String getRandomCountryCode() {
        return codes[new Random(codes.length).nextInt(codes.length)];
    }

    private static Map<String, String> getRandomNormalFields() {
        Map<String, String> normalFields = new HashMap<>(2);
        normalFields.put("message", "data update success");
        normalFields.put("countryCode", getRandomCountryCode());
        return normalFields;
    }

    public static void main(String[] args) throws Exception {
        // long size = 10000000L * 1;
        long size = 100;
        // String topicName = "log2metric1y";
        String topicName = "test";
        for (int i = 0; i < size; i++) {
            String logTypeName = "streamx_log_avro";
            String timestamp = DateUtil.getUTCTimeStr();
            String source = "/var/log/xiesen.log";
            String offset = getRandomOffset();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> measures = new HashMap<>(1);
            Map<String, String> normalFields = getRandomNormalFields();

            Map<String, Object> map = new HashMap<>();
            map.put("logTypeName", logTypeName);
            map.put("timestamp", timestamp);
            map.put("source", source);
            map.put("offset", offset);
            map.put("dimensions", dimensions);
            map.put("measures", measures);
            map.put("normalFields", normalFields);
            System.out.println(JSON.toString(map).getBytes().length);
            // CommonProducer producer = CommonProducerPool.getInstance().getProducer();
            // producer.sendLogAvro(topicName, logTypeName, timestamp, source, offset, dimensions,
            //         measures, normalFields);
        }
        Thread.sleep(1000);
    }
}
