# Kafka Producer部分参数设置及其说明
```.java
Properties props = new Properties();

props.put(ProducerConfig.BOOTSTRAP_SERVERS_CONFIG, "hadoop:9092");

/**
 * 这个参数控制着相同分区内数据发送的批次个数大小，也就是当数据达到 这个size 时，进行数据发送,
 * 但是并不是数据达不到 size 的值，就不会发送数据，默认是 1048576，即 16k
 */
props.put(ProducerConfig.BATCH_SIZE_CONFIG, 16384);

/**
 * 消息是否发送，不是仅仅通过 batch.size 的值来控制的，实际上是一种权衡策略，即吞吐量和延时之间的权衡
 * linger.ms 参数就是控制消息发送延时行为的，默认是 0，表示消息需要被立即发送。
 */
props.put(ProducerConfig.LINGER_MS_CONFIG, 1);

/**
 * 指定了producer 端用于缓存的缓存区大小，单位是字节，默认是 33554432, 即 32G
 */
props.put(ProducerConfig.BUFFER_MEMORY_CONFIG, 33554432);

/**
 * 用户控制 生产者的持久性 acks 有3个值，
 *  0: 表示producer 完全不理睬 broker 的处理结果
 *  all： 表示发送数据时，broker 不仅会将消息写入到本地磁盘，同时也要保证其他副本也写入完成，才返回结果
 *  1: 表示发送数据时，broker 接收到消息写入到本地磁盘即可，无需保证其他副本是否写入成功
 */
props.put(ProducerConfig.ACKS_CONFIG, "1");

props.put(ProducerConfig.KEY_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringSerializer");
props.put(ProducerConfig.VALUE_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.StringSerializer");
return props;
```
        