package com.zorkdata.tools.utils;

import java.io.InputStream;
import java.util.Properties;

/**
 * @author DeleMing
 */
public class PropertiesUtil {

    /**
     * 根据文件名获取该properties对象
     *
     * @param propertiesFileName 配置文件名称
     * @return properties
     */
    public static Properties getProperties(String propertiesFileName) throws Exception {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = PropertiesUtil.class.getResourceAsStream(propertiesFileName);
            properties.load(inputStream);
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return properties;
    }
}
