package com.zorkdata.tools.oldkafka;

import com.zorkdata.tools.utils.PropertiesUtil;

import java.util.Properties;

/**
 * @author MSI-Gaming
 */
public class Config {
    private static Config instance;

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public String kafkaServers;
    public int kafkaBathSize;
    public String topicName;


    private Config() {
        try {
            Properties properties = PropertiesUtil.getProperties("/config.properties");
            kafkaServers = properties.getProperty("kafka.servers");
            kafkaBathSize = Integer.parseInt(properties.getProperty("kafka.batch.size"));
            topicName = properties.getProperty("kafka.topic.name");
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
