package com.zorkdata.tools.kafka;

import com.zorkdata.tools.oldkafka.AvroSerializerFactory;
import com.zorkdata.tools.oldkafka.Config;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.util.Map;
import java.util.Properties;


/**
 * @author MSI-Gaming
 */
public class CommonProducer {

    private static String kafkaServer;
    private static int kafkaBathSize;

    private static KafkaProducer<String, byte[]> producerByte;
    private static KafkaProducer<String, String> producerString;

    public CommonProducer() {
        try {
            initConfig();
            Properties props = new Properties();
            props.put("bootstrap.servers", kafkaServer);
            props.put("client.id", "webAPI4LogGather");
            props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");

            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            props.put("batch.size", kafkaBathSize);
            producerByte = new KafkaProducer<String, byte[]>(props);
            props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            producerString = new KafkaProducer<String, String>(props);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initConfig() {
        kafkaServer = Config.getInstance().kafkaServers;
        kafkaBathSize = Config.getInstance().kafkaBathSize;
    }

    public void sendLog(String topic, String logTypeName, String timestamp, String source, String offset,
                        Map<String, String> dimensions, Map<String, Double> metrics, Map<String, String> normalFields) {
        try {
            byte[] bytes = AvroSerializerFactory.getLogAvorSerializer().serializingLog(logTypeName, timestamp, source,
                    offset, dimensions, metrics, normalFields);
            producerByte.send(new ProducerRecord<String, byte[]>(topic, null, bytes));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendLog(String topic, String logJson) {
        try {
            producerString.send(new ProducerRecord<String, String>(topic, null, logJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendErrorLog(String errorLogTopic, String logJson) {
        try {
            producerString.send(new ProducerRecord<String, String>(errorLogTopic, null, logJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendErrorMetric(String errorMetricTopic, String logJson) {
        try {
            producerString.send(new ProducerRecord<String, String>(errorMetricTopic, null, logJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAlarm(String alarmTopic, String alarmJson) {
        try {
            producerString.send(new ProducerRecord<String, String>(alarmTopic, null, alarmJson));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMetric(String metricTopic, String metricSetName, String timestamp, Map<String, String> dimensions,
                           Map<String, Double> metrics) {
        try {
            byte[] bytes = AvroSerializerFactory.getMetricAvorSerializer().serializingMetric(metricSetName, timestamp,
                    dimensions, metrics);
           producerByte.send(new ProducerRecord<String, byte[]>(metricTopic, null, bytes));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
