package com.zorkdata.tools.oldkafka;

import java.io.Closeable;
import java.io.IOException;

/**
 * ClassName: ProducerPool
 * Email: zhuzhigang@zork.com.cn
 * Date: 2018\12\13 0013
 *
 * @author: zhuzhigang
 **/

public class ProducerPool implements Closeable {

    private Producer[] pool;

    private int threadNum = 30;
    // 轮循id
    private int index = 0;

    private static ProducerPool _interance = null;

    public static ProducerPool getInstance() {
        if (_interance == null) {
            _interance = new ProducerPool();
        }
        return ProducerPool._interance;
    }

    private ProducerPool() {
        init();
    }


    public void init() {
        pool = new Producer[threadNum];
        for (int i = 0; i < threadNum; i++) {
            pool[i] = new Producer();
        }
    }

    public Producer getProducer() {
        if (index > 65535) {
            index = 0;
        }
        return pool[index++ % threadNum];
    }

    /**
     * Closes this stream and releases any system resources associated
     * with it. If the stream is already closed then invoking this
     * method has no effect.
     *
     * <p> As noted in {@link AutoCloseable#close()}, cases where the
     * close may fail require careful attention. It is strongly advised
     * to relinquish the underlying resources and to internally
     * <em>mark</em> the {@code Closeable} as closed, prior to throwing
     * the {@code IOException}.
     *
     * @throws IOException if an I/O error occurs
     */
    @Override
    public void close() throws IOException {
    }
}