package com.zorkdata.tools.mock;

import com.zorkdata.tools.kafka.CommonProducer;
import com.zorkdata.tools.kafka.CommonProducerPool;
import com.zorkdata.tools.utils.DateUtil;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * @author: LiaoMingtao
 * @date: 2020/6/30
 */
public class MockStreamxMetricAvro {

    private static final Random random = new Random();

    private static Map<String, String> getRandomDimensions() {
        int i = random.nextInt(10);
        Map<String, String> dimensions = new HashMap<>(4);
        dimensions.put("hostname", "zorkdata" + i);
        dimensions.put("ip", "192.168.1." + i);
        dimensions.put("appprogramname", "tc50");
        dimensions.put("appsystem", "tdx");
        return dimensions;
    }

    private static Map<String, Double> getMetrics() {
        Map<String, Double> metrics = new HashMap<>(1);
        int i = random.nextInt(10);
        metrics.put("metric1", i * 0.1);
        metrics.put("metric2", i * 0.2);
        metrics.put("metric3", i * 3.65);
        return metrics;
    }


    public static void main(String[] args) throws Exception {
        long size = 10000000 * 20;
        String topicName = "metric2metric20000w";
        for (int i = 0; i < size; i++) {
            String metricSetName = "streamx_metric_avro";
            String timestamp = DateUtil.getUTCTimeStr();
            Map<String, String> dimensions = getRandomDimensions();
            Map<String, Double> metrics = getMetrics();
            CommonProducer producer = CommonProducerPool.getInstance().getProducer();
            producer.sendMetricAvro(topicName, metricSetName, timestamp, dimensions, metrics);
        }
        Thread.sleep(1000);
    }
}
