package com.zorkdata.tools.mock;

import com.alibaba.fastjson.JSONObject;
import com.zorkdata.tools.kafka.CommonProducer;
import com.zorkdata.tools.kafka.CommonProducerPool;

import java.time.Instant;
import java.util.Random;

import static java.lang.System.currentTimeMillis;

/**
 * @author: LiaoMingtao
 * @date: 2020/6/30
 */
public class MockFilebeatData {

    public static String buildMsg() {
        JSONObject filebeatJson = new JSONObject();
        JSONObject metadataJson = new JSONObject();
        metadataJson.put("beat", "filebeat");
        metadataJson.put("type", "doc");
        metadataJson.put("version", "6.8.1");
        JSONObject inputJson = new JSONObject();
        inputJson.put("type", "log");
        JSONObject beatJson = new JSONObject();
        beatJson.put("name", "zorkdata-151");
        beatJson.put("hostname", "zorkdata-151");
        beatJson.put("version", "6.8.1");
        JSONObject hostJson = new JSONObject();
        hostJson.put("name", "zorkdata-151");
        hostJson.put("architecture", "x86_64");
        hostJson.put("id", "8e3dfc85999b4e02bae4adf4b92b909a");
        hostJson.put("containerized", "false");
        JSONObject logJson = new JSONObject();
        logJson.put("file", "{ \"path\": \"/var/log/nginx/access.log\" }");
        filebeatJson.put("@timestamp", Instant.now().toString());
        filebeatJson.put("source", "/var/log/nginx/access.log");
        filebeatJson.put("offset", String.valueOf(currentTimeMillis()));

        StringBuilder message = new StringBuilder();
        String strs = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (int i =0; i < 345; i++) {
            message.append(strs.charAt((int)(Math.random() * 26)));
        }
        filebeatJson.put("message", message);

        Random random = new Random();
        int i = random.nextInt(10);
        filebeatJson.put("appsystem", "test_appsystem" + i);
        filebeatJson.put("appprogramname", "test_appprogramname" + i );
        filebeatJson.put("logTypeName", "test_topic_log" + i) ;
        filebeatJson.put("servicename", "test_servicename" + i);
        filebeatJson.put("servicecode", "test_cdde" + i );
        filebeatJson.put("collectorruleid", "1");

        filebeatJson.put("@metadata", metadataJson);
        filebeatJson.put("input", inputJson);
        filebeatJson.put("beat", beatJson);
        filebeatJson.put("host", hostJson);
        filebeatJson.put("log", logJson);
        filebeatJson.put("prospector", inputJson);
        return filebeatJson.toJSONString();
    }


    public static void main(String[] args) throws InterruptedException {
        // long size = 10000000L * 10;
        String topicName = "test";
        long size = 10;
        for (int i = 0; i < size; i++) {
            String json = buildMsg();
            System.out.println(json);
            // CommonProducer producer = CommonProducerPool.getInstance().getProducer();
            // producer.sendJson(topicName, json);
        }
        Thread.sleep(1000);
    }
}
