package com.zorkdata.tools.kafka;

import com.zorkdata.tools.utils.PropertiesUtil;
import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * @author MSI-Gaming
 */
@Getter
public class Config {

    private static final Logger logger = LoggerFactory.getLogger(Config.class);

    public String kafkaServers;
    public int kafkaBathSize;
    public String topicName;

    public static final Config INSTANCE = new Config();

    /**
     * 读取配置文件
     */
    public Config() {
        try {
            Properties properties = PropertiesUtil.getProperties("/config.properties");
            kafkaServers = properties.getProperty("kafka.servers");
            kafkaBathSize = Integer.parseInt(properties.getProperty("kafka.batch.size"));
            topicName = properties.getProperty("kafka.topic.name");
        } catch (Exception e) {
            logger.error(e.toString());
            System.exit(1);
        }
    }
}
