package com.zorkdata.tools.kafka;


import java.io.Closeable;
import java.io.IOException;

/**
 * @author: LiaoMingtao
 * @date: 2020/6/29
 */
public class CommonProducerPool implements Closeable {

    private CommonProducer[] pool;

    private int threadNum = 15;


    /**
     * 轮循id
     */
    private int index = 0;

    private static CommonProducerPool producerInstance;

    public static CommonProducerPool getInstance() {
        
        if (producerInstance == null) {
            producerInstance = new CommonProducerPool();
        }
        return CommonProducerPool.producerInstance;
    }

    private CommonProducerPool() {
        init();
    }

    public void init() {
        pool = new CommonProducer[threadNum];
        for (int i = 0; i < threadNum; i++) {
            pool[i] = new CommonProducer();
        }
    }

    public CommonProducer getProducer() {
        final int maxThread = 65535;
        if (index > maxThread) {
            index = 0;
        }
        return pool[index++ % threadNum];
    }

    /**
     * Closes this stream and releases any system resources associated
     * with it. If the stream is already closed then invoking this
     * method has no effect.
     *
     * <p> As noted in {@link AutoCloseable#close()}, cases where the
     * close may fail require careful attention. It is strongly advised
     * to relinquish the underlying resources and to internally
     * <em>mark</em> the {@code Closeable} as closed, prior to throwing
     * the {@code IOException}.
     *
     * @throws IOException if an I/O error occurs
     */
    @Override
    public void close() throws IOException {
    }
}
