package com.zorkdata.tools.avro;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author DeleMing
 */
public class AvroDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(AvroDeserializer.class);
    public JSONObject jsonObject;
    public JSONArray jsonArray;
    public Schema schema;
    public String[] keys;

    public AvroDeserializer(String schema) {
        getKeysFromJson(schema);
    }

    /**
     * 用于获取Avro的keys
     *
     * @param schema Avro序列化所使用的schema
     */
    void getKeysFromJson(String schema) {
        this.jsonObject = JSONObject.parseObject(schema);
        this.schema = new Schema.Parser().parse(schema);
        this.jsonArray = this.jsonObject.getJSONArray("fields");
        this.keys = new String[this.jsonArray.size()];
        for (int i = 0; i < this.jsonArray.size(); i++) {
            this.keys[i] = this.jsonArray.getJSONObject(i).get("name").toString();
        }
    }

    /**
     * 用于Avro的反序列化
     *
     * @param body 参数：byte[] body：kafka消息。
     * @return GenericRecord
     */
    public GenericRecord deserializing(byte[] body) {
        DatumReader<GenericData.Record> datumReader = new GenericDatumReader<GenericData.Record>(this.schema);
        Decoder decoder = DecoderFactory.get().binaryDecoder(body, null);
        GenericData.Record result = null;
        try {
            result = datumReader.read(null, decoder);
        } catch (Exception e) {
            logger.error("error Avro反序列化", e);
        }
        return result;
    }
}
