# encoding=utf8
from django.db import models
from .utils.models import BaseModel


class EventInfo(BaseModel):
    department = models.CharField(null=True, max_length=64, verbose_name="用户所在部门")
    report_src = models.CharField(null=True, max_length=64, verbose_name="报告来源")
    data_src = models.CharField(null=True, max_length=64, verbose_name="数据来源", default="同步")
    failure_recovery_time = models.DateTimeField(null=True, verbose_name="故障恢复时间")
    failure_sys_name = models.CharField(null=True, max_length=64, verbose_name="故障系统名称")
    influenced_sys_name = models.TextField(null=True, verbose_name="受影响的系统名称")
    record_time = models.DateTimeField(null=True, verbose_name="事件记录日期")
    event_number = models.CharField(null=True, max_length=100, verbose_name="事件编号")
    event_exe_recovery_start_time = models.DateTimeField(null=True, verbose_name="事件处理恢复开始时间")
    event_first_category = models.CharField(null=True, max_length=64, verbose_name="事件一级分类")
    event_second_category = models.CharField(null=True, max_length=64, verbose_name="事件二级分类")
    event_third_category = models.CharField(null=True, max_length=64, verbose_name="事件三级分类")
    event_happened_time = models.DateTimeField(null=True, verbose_name="事件发生时间")
    event_closed_time = models.DateTimeField(null=True, verbose_name="事件关闭时间")
    event_urgency = models.CharField(null=True, max_length=64, verbose_name="事件紧急度")
    event_type = models.CharField(null=True, max_length=64, verbose_name="事件类型")
    event_phenomenon = models.TextField(null=True, verbose_name="事件现象")
    event_impact = models.CharField(null=True, max_length=64, verbose_name="事件影响度")
    event_priority = models.CharField(null=True, max_length=64, verbose_name="事件优先级")
    event_summary = models.TextField(null=True, verbose_name="事件摘要")
    event_change_number = models.TextField(null=True, verbose_name="事件紧急变更单号")
    event_last_update_time = models.DateTimeField(null=True, verbose_name="事件最后修改时间")
    assignee = models.CharField(null=True, max_length=64, verbose_name="受理人")
    assignee_group = models.CharField(null=True, max_length=64, verbose_name="受理人组")
    reception_time = models.DateTimeField(null=True, verbose_name="受理时间")
    commit_login_name = models.CharField(null=True, max_length=64, verbose_name="提交者登录名")
    user_reporting_time = models.DateTimeField(null=True, verbose_name="用户报障时间")
    user_phone = models.CharField(null=True, max_length=64, verbose_name="用户电话")
    user_job_number = models.CharField(null=True, max_length=64, verbose_name="用户工号")
    user_name = models.CharField(null=True, max_length=64, verbose_name="用户名")
    last_updater_login_name = models.CharField(null=True, max_length=64, verbose_name="最后修改者登录名")
    processing_person_OAID = models.CharField(null=True, max_length=64, verbose_name="处理人OAID")
    processing_person = models.CharField(null=True, max_length=64, verbose_name="处理人")
    processing_group = models.CharField(null=True, max_length=64, verbose_name="处理组")
    failure_created_influence = models.TextField(null=True, verbose_name="故障导致影响")
    failure_recovery_hour = models.IntegerField(null=True, verbose_name="故障恢复用时（小时数）")
    failure_recovery_minute = models.IntegerField(null=True, verbose_name="故障恢复用时（分钟数）")
    failure_cause_preliminary_analysis = models.TextField(null=True, verbose_name="故障原因初步分析")
    usability_impact_hour = models.IntegerField(null=True, verbose_name="可用性影响时间（小时数）")
    usability_impact_minute = models.IntegerField(null=True, verbose_name="可用性影响时间（分钟数）")
    actual_solution_hour = models.IntegerField(null=True, verbose_name="实际解决时间（小时数）")
    actual_solution_minute = models.IntegerField(null=True, verbose_name="实际解决时间（分钟数）")
    event_extra_note = models.TextField(null=True, verbose_name="事件补充注释")
    event_exec_case = models.TextField(null=True, verbose_name="处理过程")
    event_locked_state = models.CharField(null=True, max_length=64, verbose_name="事件锁定状态")
    event_commit_date = models.DateTimeField(null=True, verbose_name="事件提交日期")
    event_analysis_state = models.CharField(null=True, max_length=64, default="未分析", verbose_name="事件分析状态")
    event_state_reason = models.TextField(null=True, verbose_name="事件状态理由")
    commit_person = models.CharField(null=True, max_length=64, verbose_name="提交人")
    emergency_plans_type = models.TextField(null=True, verbose_name="应急预案场景类型")



    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_event_info"
        verbose_name = '事件基本信息'
        verbose_name_plural = verbose_name

    # def __unicode__(self):
    #     return u"事件id:%s" % self.id


# 人员信息表（同步）（无用）
class UserInfo(BaseModel):
    user_id = models.CharField(null=True, max_length=64, verbose_name="用户OAid")
    user_department = models.CharField(null=True, max_length=64, verbose_name="用户部门")
    remedy_login_id = models.CharField(null=True, max_length=64, verbose_name="用户remedy登陆id")
    phone_number = models.CharField(null=True, max_length=64, verbose_name="用户手机号")
    user_email = models.CharField(null=True, max_length=200, verbose_name="用户电子邮箱帐号")
    job_number = models.CharField(null=True, max_length=64, verbose_name="用户工号")
    job_position = models.CharField(null=True, max_length=64, verbose_name="工作职位")
    user_name = models.CharField(null=True, max_length=64, verbose_name="用户姓名")
    company = models.CharField(null=True, max_length=64, verbose_name="用户所属公司")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_user_info"
        verbose_name = '用户基本信息'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"用户信息:%s" % self.user_name


# 改进措施
class FailureMeasure(BaseModel):
    root_cause_analysis = models.TextField(null=True, verbose_name="根因分析")
    solve_method = models.TextField(null=True, verbose_name="解决方案")
    event_number = models.CharField(null=True, max_length=64, verbose_name="事件编号")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_failure_measure"
        verbose_name = '故障改进措施'
        verbose_name_plural = verbose_name

    # def __unicode__(self):
    #     return u"解决方案:%s" % self.solve_method


# 关联性分析（同步）（无用）
class RelevanceAnalysis(BaseModel):
    association_type = models.TextField(null=True, verbose_name="关联类型")
    request_type = models.TextField(null=True, verbose_name="请求类型")
    asso_result_change = models.TextField(null=True, verbose_name="关联事件引发的变更")
    event_number = models.CharField(null=True, max_length=64, verbose_name="事件编号")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_association_analysis"
        verbose_name = '关联性分析'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"关联性事件引发的变更:%s" % self.asso_result_change


class FailureAnalysis(BaseModel):
    failure_representation = models.TextField(null=True, verbose_name="故障表象")
    failure_sub_phenomenon = models.TextField(null=True, verbose_name="故障实质现象")
    solve_detail_info = models.TextField(null=True, verbose_name="解决的具体信息")
    event_number = models.CharField(null=True, max_length=64, verbose_name="事件编号")
    related_alarm_info = models.TextField(null=True, verbose_name="相关告警信息")
    monitor_src = models.TextField(null=True, verbose_name="告警实例列表")
    failure_recovery_version = models.TextField(null=True, verbose_name='故障修复版本')
    failure_in_version = models.TextField(null=True, verbose_name='故障植入版本')
    monitor_info = models.TextField(null=True, verbose_name='告警信息')

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_failure_analysis"
        verbose_name = '故障分析'
        verbose_name_plural = verbose_name

    # def __unicode__(self):
    #     return u"监控来源:%s" % self.monitor_src


# 故障分析-自动化相关
class UrgencyMeasure(BaseModel):
    urgency_info = models.TextField(null=True, verbose_name="应急方案")
    urgency_auto_info = models.TextField(null=True, verbose_name="应急方案的相关自动化信息")
    auto_sys = models.TextField(null=True, verbose_name="所属自动化系统")
    script_name = models.TextField(null=True, verbose_name="脚本名称")
    event_number = models.CharField(null=True, max_length=64, verbose_name="所属事件编号")
    auto_info = models.TextField(null=True, verbose_name="自动化信息")


    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_urgency_measure"
        verbose_name = '应急方案'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"应急方案要求:%s" % self.script_name


# 处理人的相关信息（同步）（无用）
class DealerInfo(BaseModel):
    dealer_company = models.CharField(null=True, max_length=64, verbose_name="处理人所属公司")
    dealer_organization = models.CharField(null=True, max_length=64, verbose_name="处理人所在组织")
    dealer_group_name = models.CharField(null=True, max_length=64, verbose_name="处理人所属组")
    dealer_name = models.CharField(null=True, max_length=64, verbose_name="处理人姓名")
    login_id = models.CharField(null=True, max_length=64, verbose_name="登录id")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_dealer_info"
        verbose_name = '处理人信息'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"处理人信息:%s" % self.dealer_name


# 事件一级分类与故障原因初步分析（同步）
class FailureCateReason(BaseModel):
    failure_reason_primary_analysis = models.TextField(null=True, verbose_name="事件原因初步分析")
    first_event_category = models.CharField(null=True, max_length=64, verbose_name="故障所属一级分类")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_failure_cate_reason"
        verbose_name = '故障分类及原因分析'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"故障所属一级分类:%s" % self.first_event_category


# 事件分类一二三级（同步）
class ClassificationLayer(BaseModel):
    category1 = models.CharField(null=True, max_length=100, verbose_name="事件分类层一")
    category2 = models.CharField(null=True, max_length=100, verbose_name="事件分类层二")
    category3 = models.CharField(null=True, max_length=100, verbose_name="事件分类层三")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_event_classify"
        verbose_name = '事件分类层'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"事件分类层三:%s" % self.category3


class Syetem(BaseModel):
    systemname = models.TextField(null=True, verbose_name="系统名称")
    systemcode = models.TextField(null=True, verbose_name="系统编码")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_system"
        verbose_name = '系统名称与编码'
        verbose_name_plural = verbose_name

    def __unicode__(self):
        return u"系统名称:%s" % self.systemname


class Label(models.Model):
    label_name = models.TextField(null=True, verbose_name="标签名称")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_label"
        verbose_name = '标签信息'
        verbose_name_plural = verbose_name


class EventLabel(models.Model):
    event_number = models.CharField(null=True, max_length=50, verbose_name="事件编号")
    event_label = models.TextField(null=True, verbose_name="标签列表")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_event_label"
        verbose_name = '事件标签'
        verbose_name_plural = verbose_name


class Error_alarm(models.Model):
    alarm_number = models.CharField(null=True, max_length=100, verbose_name="预警编号")
    alarm_summary = models.TextField(null=True, verbose_name="预警摘要")
    alarm_level = models.CharField(null=True, max_length=100, verbose_name="预警级别")
    alarm_system = models.TextField(null=True, verbose_name="预警系统")
    alarm_happen_time = models.DateTimeField(null=True, verbose_name="预警发生时间")
    alarm_recover_time = models.DateTimeField(null=True, verbose_name="预警恢复时间")
    if_interpose = models.CharField(null=True, max_length=100, verbose_name="是否需要干预")
    solve_process = models.TextField(null=True, verbose_name="预警处理过程")
    if_workday = models.CharField(null=True, max_length=100, verbose_name="是否为工作日")
    if_auto = models.CharField(null=True, max_length=100, verbose_name="是否自动化")
    auto_sysname = models.CharField(null=True, max_length=100, verbose_name="自动化系统")
    auto_name = models.CharField(null=True, max_length=100, verbose_name="自动化名称")
    other_autoname = models.TextField(null=True, verbose_name="其他自动化信息")
    monitor_name = models.CharField(null=True, max_length=100, verbose_name="监控名称")
    if_icube = models.CharField(null=True, max_length=100, verbose_name="是否来自一体化平台")
    user = models.CharField(null=True, max_length=100, verbose_name="处理人")

    def toDic(self):
        return dict([(attr, getattr(self, attr)) for attr in [f.name for f in self._meta.fields]])

    class Meta:
        db_table = "tb_error_alarm"
        verbose_name = '预警信息'
        verbose_name_plural = verbose_name