# encoding=utf8
from django.db import models


class BaseModel(models.Model):
    create_time = models.DateTimeField(auto_now_add=True, verbose_name='创建时间')
    update_time = models.DateTimeField(auto_now=True, verbose_name='更新时间')
    create_user = models.CharField(null=True, max_length=64, verbose_name="创建人")

    class Meta:
        # 说明这个类是一个抽象模型类，在迁移的时候不会生成表
        abstract = True
