Vue.component("code-mirror", {
    props: ["text", "type"],
    template: `<div id="editor2_demo1">
                    <div class="controls">
                        <input class="ck-code" disabled type="radio" name="script_once_type" id="script_once_type1" :checked="type=='4'" > python
                        <input class="ck-code" disabled type="radio" name="script_once_type" id="script_once_type2" :checked="type=='1'"> shell
                        <input class="ck-code" disabled type="radio" name="script_once_type" id="script_once_type3" :checked="type=='2'"> vbs
                        <input class="ck-code" disabled type="radio" name="script_once_type" id="script_once_type3" :checked="type=='3'"> perl
                        <input class="ck-code" disabled type="radio" name="script_once_type" id="script_once_type3" :checked="type=='5'"> Powershell
                    </div>
                    
                        <textarea id="editor2_script"></textarea>
                   
                    <div id='code' style='height:520px;width:820px'></div>
                    
                </div>`,

    data: function () {
        return {
            editor: null,
            scriptTypeCode: {1: 'shell',2: 'bat',3: 'perl', 4: 'python', 5: 'Powershell'}, 
        }
    },
    watch: {
        text(value) {
            this.editor.setValue(value)
            this.editor.setOption("mode", scriptTypeCode[this.type]);
            this.editor.refresh()
        
        }
    },

    

    mounted() {
        // this.text = this.scriptText
        // setTimeout(() => {
            this.editor = CodeMirror.fromTextArea($("#editor2_script")[0], { //script_once_code为你的textarea的ID号
                lineNumbers: true,//是否显示行号
                //默认脚本编码
                lineWrapping: true, //是否强制换行
                // indentUnit: 4, // 缩进单位，值为空格数，默认为2 。
                matchBrackets: true,
                theme: "ambiance",
                autofocus: true
            });
            this.editor.setSize('820px', '520px')
            // this.editor.setReadOnly(true); 
        // })
    }
})

Vue.component("pages", {
    template: ` <nav>
        <ul id="pagination">
        <li :class="{'disabled': current == 1}"><a href="javascript:;" @click="setCurrent(current - 1)"> « </a></li>
        <li :class="{'disabled': current == 1}"><a href="javascript:;" @click="setCurrent(1)"> 首页 </a></li>
        <li v-for="p in grouplist" :class="{'active': current == p.val}"><a href="javascript:;"
                                                                            @click="setCurrent(p.val)"> {{ p.text }} </a>
        </li>
        <li :class="{'disabled': current == page}"><a href="javascript:;" @click="setCurrent(page)"> 尾页 </a></li>
        <li :class="{'disabled': current == page}"><a href="javascript:;" @click="setCurrent(current + 1)"> »</a></li>
        </ul>
    </nav>`,
    data() {
        return {
            current: this.currentPage
        }
    },
    props: {
        total: {// 数据总条数
            type: Number,
            default: 0
        },
        display: {// 每页显示条数
            type: Number,
            default: 50
        },
        currentPage: {// 当前页码
            type: Number,
            default: 1
        },
        pagegroup: {// 分页条数
            type: Number,
            default: 5,
            coerce: function (v) {
                v = v > 0 ? v : 5;
                return v % 2 === 1 ? v : v + 1;
            }
        }
    },
    computed: {
        page: function () { // 总页数
            return Math.ceil(this.total / this.display);
        },
        grouplist: function () { // 获取分页页码
            var len = this.page, temp = [], list = [], count = Math.floor(this.pagegroup / 2), center = this.current;
            if (len <= this.pagegroup) {
                while (len--) {
                    temp.push({ text: this.page - len, val: this.page - len });
                }
                ;
                return temp;
            }
            while (len--) {
                temp.push(this.page - len);
            }
            ;
            var idx = temp.indexOf(center);
            (idx < count) && (center = center + count - idx);
            (this.current > this.page - count) && (center = this.page - count);
            temp = temp.splice(center - count - 1, this.pagegroup);
            do {
                var t = temp.shift();
                list.push({
                    text: t,
                    val: t
                });
            } while (temp.length);
            if (this.page > this.pagegroup) {
                (this.current > count + 1) && list.unshift({ text: '...', val: list[0].val - 1 });
                (this.current < this.page - count) && list.push({ text: '...', val: list[list.length - 1].val + 1 });
            }
            return list;
        }
    },
    methods: {
        setCurrent: function (idx) {
            if (this.current != idx && idx > 0 && idx < this.page + 1) {
                this.current = idx;
                this.$emit('pagechange', this.current);
            }
        }
    }
})

Vue.component("model-info", {
    props: [],
    template: `
        
    `
})