
//模拟异步请求
function get(url) {
    // var baseUrl = "http://local.blueking.com:8000";
    // url += baseUrl;
    return new Promise((resolve, reject) => {
        $.ajax({
            url: url,
            dataType: "json",
            type: "get",
            success: function (info) {
                resolve(info)
            },
            error: function (err) {
                reject(err)
            }
        })
    })
}

function post(url, param) {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: url,
            data: param,
            type: "post",
            dataType: "json",
            before: function (xhr) {
                xhr.setRequestHeader("Content-Type", "application/json;");
            },
            success: function (info) {
                resolve(info)
            },
            error: function (err) {
                reject(err)
            }
        })
    })
}


//执行历史实例
var history = new Vue({
    el: "#demo2",
    data: {
        machineList: [],
        machineInfo: "",
        isDetail: true,
        machineDeatilInfo: [],
        stateCode: {
            0: '正在执行', 1: '未执行', 2: '正在执行', 3: '执行成功', 4: '执行失败', 5: '跳过',
            6: '忽略错误', 7: '等待用户', 8: '手动结束', 9: '状态异常',
            10: '步骤强制终止中', 11: '步骤强制终止成功', 12: '步骤强制终止失败'
        },
        scriptTypeCode: { 1: 'shell', 2: 'bat', 3: 'perl', 4: 'python', 5: 'Powershell' },
        total: 50,
        display: 50,
        current: 1,
        loadingList: false,
        getBizHostList: [],
        getBiz: {},
        findExcuteList: [],
        ip: "",
        bkBizName: "",
        hostNameList: [],
        select: -9,
        hostHistory: [],
        item: {},
        select2: -9
    },
    methods: {
        // showDetail(data) {
        //     this.machineInfo = data;
        //     this.isDetail = false;
        //     post("mission/getAgentTaskInfo/", JSON.stringify({ "taskID": data.taskID })).then(info => {
        //         this.machineDeatilInfo.push(info.data)
        //     }).catch(err => {
        //         console.log(err)
        //     })
        // },

        // goBack() {
        //     this.isDetail = true;
        //     this.machineDeatilInfo = []
        // },
        // pagechange(current) {
        //     this.loadingList = true;
        //     post("mission/getExecuteHistory/", JSON.stringify({ "currentPage": current })).then(info => {
        //         this.machineList = info.data.resultList;
        //         this.total = info.data.count;
        //         this.current = current
        //         this.loadingList = false;
        //     }).catch(err => {
        //         console.log(err)
        //     });
        // },
        getHostMission(ip, i) {
            this.select = i
            this.select2 = -9
            post("mission/getHostMission/", JSON.stringify({ "ip": ip })).then(info => {
                console.log(info)
                this.findExcuteList = info.data
                return ip
            })
        },
        getHistory(item, ip, i) {
            this.item = item
            this.select2 = i
            this.loadingList = true
            post("mission/getExecuteHistory/", JSON.stringify({ "ip": ip, "taskId": item.id })).then(info => {
               this.hostHistory = info.data.resultList
               console.log(this.hostHistory, info)
               this.loadingList = false
            })
        }
    },
    mounted() {
        get("getBizHostList/").then(info => {
            console.log("业务和机器信息", info)
            if(info.result) {
                this.getBiz = Object.keys(info.data)
                this.bkBizName = this.getBiz[0]
                this.getBizHostList = info.data
                this.hostNameList = this.getBizHostList[this.bkBizName]
            }
        })
    },
    created() {
        
    },
    watch: {
        bkBizName(value) {
            this.bkBizName = value;
            this.hostNameList = this.getBizHostList[value]
            this.select = -9
            this.select2 = -9
            this.findExcuteList = []
        }
    }
})


