const newBuildTask = new Vue({
    el: "#demo3",
    data: {
        scriptGroup: [],
        scriptText: "",
        scriptID: '',
        scriptList: [],
        scriptSelected: [],
        newScriptParam: {},
        inputParam: [],
        outParam: [],
        step: 1,
        scriptType: "",
        initCode: false,
        linuxUser: "root",
        windowsUser: "Administrator",
        searchBiz: "",
        selectedMission: "",
        // groupMissionList: [],
        selectAll: false,
        account_ip_list: {
            root: [],
            Administrator: []
        },
        isNew: true,
        findType: ["硬件资源类", "网络资源类", "业务中间件", "应用中间件", "服务关系类"],
        scriptTypeCode: { 1: 'shell', 2: 'bat', 3: 'perl', 4: 'python', 5: 'Powershell' },
        taskAgentList: [],
        outShow: false,
        inShow: false,
        selectedScriptItem: [],
        MissionList: [],
        keyWord: ""
    },
    methods: {
        selectedSCript(e) {
            
            $(".bs-example-modal-lg").modal("show")

        },

        getGroupAndScript(){
            axios.get("script/getScriptGroup/")
                .then(response => {
                    this.scriptGroup = response.data.data.scriptGroup[0].children;
                    console.log(this.scriptGroup)
                    this.scriptID = this.scriptGroup[0].id
                    this.newScriptParam.findType = this.scriptGroup[0].name
                    this.getScript()
                })
                .catch((error) => {
                });
        },
        previewScript() {
            // data-toggle="modal" data-target=".bs-preview-modal-lg"
            $(".bs-preview-modal-lg").modal("show")
            this.initCode = true;
        },
        getScript() {
            var url = "script/getScript/";
            var param = JSON.stringify({ "scriptGroupID": this.scriptID })
            axios.post(url, param)
                .then(res => {
                    if (res.data.result) {
                        console.log(res)
                        this.scriptList = res.data.data.scriptList
                    } else {
                        this.scriptList = []
                    }
                })
                .catch((error) => {
                });
        },
        selectedScript(id) {
            this.scriptList.forEach(val => {
                if (val.script_id !== id) {
                    val.select = false
                }
            })
        },
        ensureScript() {
            var selected = this.scriptList.filter(val => val.select == true)
            if (selected.length == 0) {
                toastr["warning"]("<br>当前提示类型: 当前没有选中的脚本！")
            } else {
                this.scriptSelected = selected[0]
                this.scriptText = this.scriptSelected.scriptText
                this.scriptType = this.scriptSelected.scriptType
                $(".bs-example-modal-lg").modal("hide")
            }
        },

        dblEnsureScript(item) {
            item.select = true
            this.selectedScript(item.script_id)
            this.ensureScript()
        },
        addParam(str) {
            if (str == 'in') {
                this.inputParam.push({})
            }
            if (str == 'out') {
                this.outParam.push({})
            }

            if (str == 'ing') {
                this.inShow = !this.inShow
            }
            if (str == 'outln') {
                this.outShow = !this.outShow
            }

        },
        deleteParam(i, str) {
            this.inputParam.splice(i, 1);
            if (str == 'in') {
                this.inputParam.splice(i, 1)
            } else {
                this.outParam.splice(i, 1)
            }
        },
        nextStep() {
            console.log($("#corn-value").val())
            if (this.isNew) {
                if (this.scriptSelected.script_id) {
                    if (this.newScriptParam.findName == '' || !this.newScriptParam.findName) {
                        toastr['warning']("<br>当前提示类型：请填写脚本名称！")
                        return
                    }
                    if (this.newScriptParam.description == '' || !this.newScriptParam.description) {
                        toastr['warning']("<br>当前提示类型：请填写脚本描述！")
                        return
                    }

                    this.newScriptParam.scriptID = this.scriptSelected.script_id;


                    console.log("inputParam:", this.newScriptParam)
                } else {
                    toastr['warning']("<br>当前提示类型：当前没有选择脚本，请选择脚本")
                    return
                }
            }
            this.step = 2;
            this.newScriptParam.runTime = $("#corn-value").val()
            this.newScriptParam.inputParam = this.inputParam;
            this.newScriptParam.createUser = $(".user-name").text()
        },
        prevStep() {
            this.step = 1
        },
        selectMachine(id) {
            post("search_host/", JSON.stringify({ "bk_biz_id": id })).then(info => {
                console.log(info)
                if (info.result) {
                    this.MissionList = info.data.hostList;
                }
            })
        },
        selectHost(info) {
            if (info.select) {
                if (info.os_type == "windows") {
                    this.account_ip_list.Administrator.push({
                        "bk_cloud_id": info.bk_cloud_id,
                        "ip": info.ip
                    })
                } else {
                    this.account_ip_list.root.push({
                        "bk_cloud_id": info.bk_cloud_id,
                        "ip": info.ip
                    })
                }
            } else {
                if (info.os_type == "windows") {
                    this.account_ip_list.Administrator = this.account_ip_list.Administrator.filter(val => val.ip !== info.ip)
                } else {
                    this.account_ip_list.root = this.account_ip_list.root.filter(val => val.ip !== info.ip)
                }
            }
            console.log(this.account_ip_list)
        },
        //保存数据并提交新建的任务
        completeNewTask() {
            console.log(this.account_ip_list.Administrator)
            this.newScriptParam.account_ip_list = {}
            this.newScriptParam.account_ip_list[this.windowsUser] = this.account_ip_list['Administrator'];
            this.newScriptParam.account_ip_list[this.linuxUser] = this.account_ip_list['root'];
            this.newScriptParam.bk_biz_id = this.selectedMission
            if (this.account_ip_list['Administrator'].length == 0 && this.account_ip_list['root'].length == 0) {
                toastr['warning']('<br>当前提示类型：请选择机器', {
                    positionClass: "toast-top-center"
                });
            } else {
                var url;
                if (!this.isNew) {
                    url = "mission/updateMission/"
                } else {
                    url = "mission/createMission/"
                }
                post(url, JSON.stringify(this.newScriptParam)).then(info => {
                    toastr['success']('<br>当前提示类型：' + info.message);
                    if (info.result) {
                        this.step = 3;
                        get("mission/getMissionList/").then(data => {
                            var missionList = data.data.display_list
                            vm.$data.findexcuteList = missionList;
                            var newMission = missionList[missionList.length - 1]
                            post("mission/getTaskAgentList/", JSON.stringify({ "taskID": newMission.taskID })).then(data => {
                                if (!info.result) {
                                    this.taskAgentList = info.data.displayList
                                }
                            })
                            this.loadingList = false;
                        })
                        get("getBizHostList/").then(info => {
                            if(info.result) {
                                history.$data.getBiz = 
                                history.$data.getBiz =  Object.keys(info.data)
                                history.$data.bkBizName = history.$data.getBiz[0]
                                history.$data.getBizHostList = info.data
                                history.$data.hostNameList = history.$data.getBizHostList[this.bkBizName]
                            }
                        })
                        swal( '新建脚本成功', '你点击了按钮！', 'success' )
                        this.newScriptParam = {}
                        this.inputParam = {};
                        this.scriptSelected = {}
                        this.step = 3;
                        this.selectMachine(this.selectedMission)
                        this.updataSearchBiz()
                        this.isNew = true;
                        this.goback()
                        this.getGroupAndScript()
                        $(".find-mission").tab("show");
                    }
                })
            }

        },
        updataSearchBiz() {
            get("search_biz/").then((data) => {
                // console.log(data, textStatus)
                if (data.result) {
                    var bkArr = []
                    for (var i = 0; i < data.data.bizList.length; i++) {
                        bkArr.push({
                            id: data.data.bizList[i].bk_biz_id,
                            text: data.data.bizList[i].bk_biz_name
                        })
                    }
                    this.searchBiz = bkArr
                    this.selectedMission = this.searchBiz[0].id
                    this.selectMachine(this.selectedMission)
                } else {

                }
            });
        },
        goback() {
            this.step = 1;
            this.isNew = true;
            this.newScriptParam = {};
            this.scriptSelected = {}
        },
        selectType() {
        },
        abolish() {
            $(".find-mission").tab("show")
            this.isNew = true;
            this.newScriptParam = {};
            this.scriptSelected = {}
            this.scriptText = ''
            this.scriptType = ''
        }
    },
    computed: {
        groupMissionList: function() {
            return this.MissionList.filter( list => {
                return list.ip.indexOf(this.keyWord) > -1
            })
        }
    },
    mounted() {
        var regularExcute = new RegularExcute();
        regularExcute.init();
        this.getGroupAndScript()

    },

    updated() {

    },
    beforeCreate() {
        get("search_biz/").then((data) => {
            // console.log(data, textStatus)
            if (data.result) {
                var bkArr = []
                for (var i = 0; i < data.data.bizList.length; i++) {
                    bkArr.push({
                        id: data.data.bizList[i].bk_biz_id,
                        text: data.data.bizList[i].bk_biz_name
                    })
                }
                this.searchBiz = bkArr
                this.selectedMission = this.searchBiz[0].id
                this.selectMachine(this.selectedMission)
            } else {

            }
        });
    },
    watch: {
        step(value) {
            if (value == 2) {
                var that = this
                $("#plugin3_demo2 .select2_box").select2({ width: "230", data: this.searchBiz })
                    .on("select2:select", (e) => {
                        console.log(e.params.data.id)
                        this.selectedMission = e.params.data.id;
                        that.selectMachine(this.selectedMission)
                    })
            }
        },
        selectedMission(value) {
            console.log(value)
        },
        selectAll(value) {
            this.account_ip_list.root = []
            this.account_ip_list.Administrator = []
            if (value) {
                this.groupMissionList.forEach(val => {
                    val.select = true
                })
                this.account_ip_list.root = this.groupMissionList.filter(val => val.os_type == 'linux')
                this.account_ip_list.Administrator = this.groupMissionList.filter(val => val.os_type == 'windows')
            } else {
                this.groupMissionList.forEach(val => {
                    val.select = false
                })
                this.account_ip_list.root = []
                this.account_ip_list.Administrator = []
            }
            console.log(this.account_ip_list)
        },
        scriptID(value) {
            if(this.scriptGroup.length > 0) {
                this.newScriptParam.findType = this.scriptGroup.filter(val => {
                    return val.id == value
                })[0].name
                console.log(this.newScriptParam.findType)
                console.log('scriptID', this.scriptID)
                this.getScript()
            }
            
        }
    },
    created() {
        $(window).scroll(() => {
            console.log($(this).scrollTop())
        })
    },
})