/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collection;
import java.util.Date;
import org.jolokia.Version;
import org.jolokia.jvmagent.security.PKCS1Util;
import org.jolokia.util.Base64Util;
import org.jolokia.util.ClassUtil;

public class KeyStoreUtil {
    private static final String KEYGEN_CLASS_JDK8_SUN = "sun.security.tools.keytool.CertAndKeyGen";
    private static final String KEYGEN_CLASS_JDK7_SUN = "sun.security.x509.CertAndKeyGen";
    private static final String KEYGEN_CLASS_JDK8_IBM = "com.ibm.security.tools.CertAndKeyGen";
    private static final String KEYGEN_CLASS_JDK7_IBM = "com.ibm.security.x509.CertAndKeyGen";
    private static final String X500_NAME_SUN = "sun.security.x509.X500Name";
    private static final String X500_NAME_IBM = "com.ibm.security.x509.X500Name";

    private KeyStoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithCaPem(KeyStore pTrustStore, File pCaCert) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream is = new FileInputStream(pCaCert);
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> certificates = certFactory.generateCertificates(is);
            for (Certificate certificate : certificates) {
                X509Certificate cert = (X509Certificate)certificate;
                String alias = cert.getSubjectX500Principal().getName();
                pTrustStore.setCertificateEntry(alias, cert);
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithServerPems(KeyStore pKeyStore, File pServerCert, File pServerKey, String pKeyAlgo, char[] pPassword) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        FileInputStream is = new FileInputStream(pServerCert);
        try {
            PrivateKey privateKey;
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
            byte[] keyBytes = KeyStoreUtil.decodePem(pServerKey);
            KeyFactory keyFactory = KeyFactory.getInstance(pKeyAlgo);
            try {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
            }
            catch (InvalidKeySpecException e) {
                RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes);
                privateKey = keyFactory.generatePrivate(keySpec);
            }
            String alias = cert.getSubjectX500Principal().getName();
            pKeyStore.setKeyEntry(alias, privateKey, pPassword, new Certificate[]{cert});
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static void updateWithSelfSignedServerCertificate(KeyStore pKeyStore) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeyException, CertificateException, SignatureException, KeyStoreException {
        Object x500Name;
        Object[] certAttributes = new Object[]{"Jolokia Agent " + Version.getAgentVersion(), "JVM", "jolokia.org", "Pegnitz", "Franconia", "DE"};
        if (ClassUtil.checkForClass(X500_NAME_SUN)) {
            x500Name = ClassUtil.newInstance(X500_NAME_SUN, certAttributes);
        } else if (ClassUtil.checkForClass(X500_NAME_IBM)) {
            x500Name = ClassUtil.newInstance(X500_NAME_IBM, certAttributes);
        } else {
            throw new IllegalStateException("Neither Sun- nor IBM-style JVM found.");
        }
        Object keypair = KeyStoreUtil.createKeyPair();
        PrivateKey privKey = KeyStoreUtil.getPrivateKey(keypair);
        Certificate[] chain = new X509Certificate[]{KeyStoreUtil.getSelfCertificate(keypair, x500Name, new Date(), 315360000L)};
        pKeyStore.setKeyEntry("jolokia-agent", privKey, new char[0], chain);
    }

    private static Object createKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Class keyGenClass = KeyStoreUtil.lookupKeyGenClass();
        Object keypair = ClassUtil.newInstance(keyGenClass, "RSA", "SHA1WithRSA");
        ClassUtil.applyMethod(keypair, "generate", 2048);
        return keypair;
    }

    private static X509Certificate getSelfCertificate(Object keypair, Object x500Name, Date date, long l) {
        Class clazz = ClassUtil.checkForClass(X500_NAME_SUN) ? ClassUtil.classForName(X500_NAME_SUN, false, new ClassLoader[0]) : ClassUtil.classForName(X500_NAME_IBM, false, new ClassLoader[0]);
        try {
            Method selfCertMethod = keypair.getClass().getDeclaredMethod("getSelfCertificate", clazz, Date.class, Long.TYPE);
            selfCertMethod.setAccessible(true);
            return (X509Certificate)selfCertMethod.invoke(keypair, x500Name, date, l);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Found no getSelfCertificate-method with the expected signature.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Not allowed to access getSelfCertificate-method.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The getSelfCertificate-method threw an error.", e);
        }
    }

    private static PrivateKey getPrivateKey(Object keypair) {
        return (PrivateKey)ClassUtil.applyMethod(keypair, "getPrivateKey", new Object[0]);
    }

    private static Class lookupKeyGenClass() {
        String keyGenCandidate;
        Class keyGenClass = null;
        String[] stringArray = new String[]{KEYGEN_CLASS_JDK8_SUN, KEYGEN_CLASS_JDK7_SUN, KEYGEN_CLASS_JDK8_IBM, KEYGEN_CLASS_JDK7_IBM};
        int n = stringArray.length;
        for (int i = 0; i < n && (keyGenClass = ClassUtil.classForName(keyGenCandidate = stringArray[i], new ClassLoader[0])) == null; ++i) {
        }
        if (keyGenClass == null) {
            throw new IllegalStateException("Cannot find any key-generator class: Tried Sun Java 8's sun.security.tools.keytool.CertAndKeyGen, Sun Java 7's sun.security.x509.CertAndKeyGen, IBM Java 8's com.ibm.security.tools.CertAndKeyGen and IBM Java 7's com.ibm.security.x509.CertAndKeyGen");
        }
        return keyGenClass;
    }

    private static byte[] decodePem(File pemFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(pemFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = KeyStoreUtil.readBytes(pemFile, reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM " + pemFile + " is invalid: no begin marker");
        }
        finally {
            reader.close();
        }
    }

    private static byte[] readBytes(File pemFile, BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return Base64Util.decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException(pemFile + " is invalid : No end marker");
    }
}

