/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.ProcessDescription;
import org.jolokia.jvmagent.client.util.ProcessingException;
import org.jolokia.jvmagent.client.util.ToolsClassFinder;

public class VirtualMachineHandler {
    private OptionsAndArgs options;

    public VirtualMachineHandler(OptionsAndArgs pOptions) {
        this.options = pOptions;
    }

    public Object attachVirtualMachine() {
        if (this.options.getPid() == null && this.options.getProcessPattern() == null) {
            return null;
        }
        Class vmClass = this.lookupVirtualMachineClass();
        String pid = null;
        try {
            Method method = vmClass.getMethod("attach", String.class);
            pid = this.getProcessId(this.options);
            return method.invoke(null, pid);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Internal: No method 'attach' found on " + vmClass, e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "InvocationTarget", vmClass), e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(this.getPidErrorMesssage(pid, "IllegalAccessException", vmClass), e, this.options);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException("Illegal Argument", e, this.options);
        }
    }

    private String getPidErrorMesssage(String pid, String label, Class vmClass) {
        return pid != null ? String.format("Cannot attach to process-ID %s (%s %s).\nSee --help for possible reasons.", pid, label, vmClass.getName()) : String.format("%s %s", label, vmClass.getName());
    }

    public void detachAgent(Object pVm) {
        try {
            if (pVm != null) {
                Class<?> clazz = pVm.getClass();
                Method method = clazz.getMethod("detach", new Class[0]);
                method.setAccessible(true);
                method.invoke(pVm, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
    }

    public List<ProcessDescription> listProcesses() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<ProcessDescription> ret = new ArrayList<ProcessDescription>();
        Class vmClass = this.lookupVirtualMachineClass();
        Method method = vmClass.getMethod("list", new Class[0]);
        List vmDescriptors = (List)method.invoke(null, new Object[0]);
        for (Object descriptor : vmDescriptors) {
            Method idMethod = descriptor.getClass().getMethod("id", new Class[0]);
            String id = (String)idMethod.invoke(descriptor, new Object[0]);
            Method displayMethod = descriptor.getClass().getMethod("displayName", new Class[0]);
            String display = (String)displayMethod.invoke(descriptor, new Object[0]);
            ret.add(new ProcessDescription(id, display));
        }
        return ret;
    }

    public ProcessDescription findProcess(Pattern pPattern) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList<ProcessDescription> ret = new ArrayList<ProcessDescription>();
        String ownId = this.getOwnProcessId();
        for (ProcessDescription desc : this.listProcesses()) {
            Matcher matcher = pPattern.matcher(desc.getDisplay());
            if (desc.getId().equals(ownId) || !matcher.find()) continue;
            ret.add(desc);
        }
        if (ret.size() == 1) {
            return (ProcessDescription)ret.get(0);
        }
        if (ret.size() == 0) {
            throw new IllegalArgumentException("No attachable process found matching \"" + pPattern.pattern() + "\"");
        }
        StringBuilder buf = new StringBuilder();
        for (ProcessDescription desc : ret) {
            buf.append(desc.getId()).append(" (").append(desc.getDisplay()).append("),");
        }
        throw new IllegalArgumentException("More than one attachable process found matching \"" + pPattern.pattern() + "\": " + buf.substring(0, buf.length() - 1));
    }

    private String getProcessId(OptionsAndArgs pOpts) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (pOpts.getPid() != null) {
            return pOpts.getPid();
        }
        if (pOpts.getProcessPattern() != null) {
            return this.findProcess(pOpts.getProcessPattern()).getId();
        }
        throw new IllegalArgumentException("No process ID and no process name pattern given");
    }

    private String getOwnProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int endIdx = name.indexOf(64);
        return endIdx != -1 ? name.substring(0, endIdx) : name;
    }

    private Class lookupVirtualMachineClass() {
        try {
            return ToolsClassFinder.lookupClass("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException exp) {
            throw new ProcessingException("Cannot find classes from tools.jar. The heuristics for loading tools.jar which contains\nessential classes for attaching to a running JVM could locate the necessary jar file.\n\nPlease call this launcher with a qualified classpath on the command line like\n\n   java -cp path/to/tools.jar:" + this.options.getJarFileName() + " org.jolokia.jvmagent.client.AgentLauncher [options] <command> <ppid>\n", exp, this.options);
        }
    }
}

